/*
 * Decompiled with CFR 0.152.
 */
package org.coindirect.centrifuge.java.it;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.coindirect.centrifuge.java.Centrifugo;
import org.coindirect.centrifuge.java.TestWebapp;
import org.coindirect.centrifuge.java.config.ReconnectConfig;
import org.coindirect.centrifuge.java.credentials.Token;
import org.coindirect.centrifuge.java.credentials.User;
import org.coindirect.centrifuge.java.listener.ConnectionListener;
import org.coindirect.centrifuge.java.listener.SubscriptionListener;
import org.coindirect.centrifuge.java.subscription.SubscriptionRequest;
import org.coindirect.centrifuge.java.util.DataLock;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.RobolectricGradleTestRunner;
import org.testcontainers.containers.GenericContainer;

@RunWith(value=RobolectricGradleTestRunner.class)
@Ignore
public class AutoReconnectTests {
    public GenericContainer centrifugo;
    private MockWebServer mockWebServer;

    @Before
    public void beforeMethod() throws Exception {
        this.centrifugo = new GenericContainer("samvimes/centrifugo-with-web:1.3").withExposedPorts(new Integer[]{8000});
        this.centrifugo.start();
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.start();
    }

    @After
    public void afterMethod() throws Exception {
        this.mockWebServer.shutdown();
        this.centrifugo.stop();
    }

    @Test
    public void testAutoReconnectAfterConnectionLoss() throws Exception {
        String containerIpAddress = this.centrifugo.getContainerIpAddress() + ":" + this.centrifugo.getMappedPort(8000);
        String centrifugoAddress = "ws://" + containerIpAddress + "/connection/websocket";
        String centrifugoApiAddress = "http://" + containerIpAddress + "/api/";
        this.mockWebServer.setDispatcher((Dispatcher)new TestWebapp());
        String url = this.mockWebServer.url("/tokens").toString();
        OkHttpClient okHttpClient = new OkHttpClient();
        Request build = new Request.Builder().url(url).build();
        Response execute = okHttpClient.newCall(build).execute();
        String body = execute.body().string();
        JSONObject loginObject = new JSONObject(body);
        String userId = loginObject.optString("userId");
        String timestamp = loginObject.optString("timestamp");
        String token = loginObject.optString("token");
        final RemoteProblemCentrifugo centrifugo = (RemoteProblemCentrifugo)new RemoteProblemCentrifugo.Builder(centrifugoAddress).setUser(new User(userId, null)).setToken(new Token(token, timestamp)).setReconnectConfig(new ReconnectConfig(3, 1L, TimeUnit.SECONDS)).build();
        final DataLock connected = new DataLock();
        final DataLock disconnected = new DataLock();
        final DataLock reConnected = new DataLock();
        final DataLock disconnectedAgain = new DataLock();
        centrifugo.setConnectionListener(new ConnectionListener(){

            public void onWebSocketOpen() {
            }

            public void onConnected() {
                connected.setData(true);
            }

            public void onDisconnected(int code, String reason, boolean remote) {
                centrifugo.setConnectionListener(new ConnectionListener(){

                    public void onWebSocketOpen() {
                        reConnected.setData(true);
                    }

                    public void onConnected() {
                    }

                    public void onDisconnected(int code, String reason, boolean remote) {
                        disconnectedAgain.setData(true);
                    }
                });
                disconnected.setData(!remote);
            }
        });
        centrifugo.connect();
        Assert.assertTrue((String)"Failed to connect to centrifugo", (boolean)((Boolean)connected.lockAndGet()));
        final DataLock channelSubscription = new DataLock();
        centrifugo.setSubscriptionListener(new SubscriptionListener(){

            public void onSubscribed(String channelName) {
                channelSubscription.setData(channelName);
            }

            public void onUnsubscribed(String channelName) {
            }

            public void onSubscriptionError(String channelName, String error) {
            }
        });
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("test-channel");
        centrifugo.subscribe(subscriptionRequest);
        Assert.assertEquals((Object)"test-channel", channelSubscription.lockAndGet());
        final DataLock channelRESubscription = new DataLock();
        centrifugo.setSubscriptionListener(new SubscriptionListener(){

            public void onSubscribed(String channelName) {
                channelRESubscription.setData(channelName);
            }

            public void onUnsubscribed(String channelName) {
            }

            public void onSubscriptionError(String channelName, String error) {
            }
        });
        centrifugo.disconnect();
        Assert.assertTrue((String)"Failed to REconnect to centrifugo", (boolean)((Boolean)reConnected.lockAndGet()));
        Assert.assertEquals((String)"Failed to REsubscruibe to test-channel", (Object)"test-channel", channelRESubscription.lockAndGet());
        centrifugo.setRemoteProblem(false);
        centrifugo.disconnect();
        Assert.assertTrue((String)"Failed to properly disconnect to centrifugo", (boolean)((Boolean)disconnectedAgain.lockAndGet()));
    }

    private JSONObject sendMessageJson(String channel, JSONObject message) {
        JSONObject sendMessageJson = new JSONObject();
        try {
            sendMessageJson.put("method", (Object)"publish");
            JSONObject params = new JSONObject();
            params.put("channel", (Object)channel);
            params.put("data", (Object)message);
            sendMessageJson.put("params", (Object)params);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return sendMessageJson;
    }

    private static class RemoteProblemCentrifugo
    extends Centrifugo {
        private boolean remoteProblem = true;

        private RemoteProblemCentrifugo(String wsURI, String userId, String clientId, String token, String tokenTimestamp, String info) {
            super(wsURI, userId, clientId, token, tokenTimestamp, info);
        }

        public void setRemoteProblem(boolean remoteProblem) {
            this.remoteProblem = remoteProblem;
        }

        public void onClose(int code, String reason, boolean remote) {
            super.onClose(code, reason, this.remoteProblem);
        }

        public static class Builder {
            @Nonnull
            private String wsURI;
            private User user;
            private Token token;
            @Nullable
            private String info;
            @Nullable
            private ReconnectConfig reconnectConfig;

            public Builder(@Nonnull String wsURI) {
                this.wsURI = wsURI;
            }

            public Builder setToken(@Nonnull Token token) {
                this.token = token;
                return this;
            }

            public Builder setUser(@Nonnull User user) {
                this.user = user;
                return this;
            }

            public Builder setInfo(@Nullable String info) {
                this.info = info;
                return this;
            }

            public Builder setReconnectConfig(@Nullable ReconnectConfig reconnectConfig) {
                this.reconnectConfig = reconnectConfig;
                return this;
            }

            public Centrifugo build() {
                if (this.user == null) {
                    throw new NullPointerException("user info not provided");
                }
                if (this.token == null) {
                    throw new NullPointerException("token not provided");
                }
                RemoteProblemCentrifugo remoteProblemCentrifugo = new RemoteProblemCentrifugo(this.wsURI, this.user.getUser(), this.user.getClient(), this.token.getToken(), this.token.getTokenTimestamp(), this.info);
                remoteProblemCentrifugo.setReconnectConfig(this.reconnectConfig);
                return remoteProblemCentrifugo;
            }
        }
    }
}

