/*
 * Decompiled with CFR 0.152.
 */
package org.coindirect.centrifuge.java.it;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.coindirect.centrifuge.java.Centrifugo;
import org.coindirect.centrifuge.java.TestWebapp;
import org.coindirect.centrifuge.java.credentials.Token;
import org.coindirect.centrifuge.java.credentials.User;
import org.coindirect.centrifuge.java.listener.ConnectionListener;
import org.coindirect.centrifuge.java.listener.DataMessageListener;
import org.coindirect.centrifuge.java.listener.SubscriptionListener;
import org.coindirect.centrifuge.java.message.DataMessage;
import org.coindirect.centrifuge.java.message.history.HistoryItem;
import org.coindirect.centrifuge.java.message.history.HistoryMessage;
import org.coindirect.centrifuge.java.subscription.SubscriptionRequest;
import org.coindirect.centrifuge.java.util.DataLock;
import org.coindirect.centrifuge.java.util.Signing;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.RobolectricGradleTestRunner;
import org.testcontainers.containers.GenericContainer;

@RunWith(value=RobolectricGradleTestRunner.class)
@Ignore
public class HistoryTests {
    public GenericContainer centrifugo;
    private MockWebServer mockWebServer;

    @Before
    public void beforeMethod() throws Exception {
        this.centrifugo = new GenericContainer("samvimes/centrifugo-with-web:1.3").withExposedPorts(new Integer[]{8000});
        this.centrifugo.start();
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.start();
    }

    @After
    public void afterMethod() throws Exception {
        this.mockWebServer.shutdown();
        this.centrifugo.stop();
    }

    @Test
    public void testHistoryRequest() throws Exception {
        String containerIpAddress = this.centrifugo.getContainerIpAddress() + ":" + this.centrifugo.getMappedPort(8000);
        String centrifugoAddress = "ws://" + containerIpAddress + "/connection/websocket";
        String centrifugoApiAddress = "http://" + containerIpAddress + "/api/";
        this.mockWebServer.setDispatcher((Dispatcher)new TestWebapp());
        String url = this.mockWebServer.url("/tokens").toString();
        OkHttpClient okHttpClient = new OkHttpClient();
        Request build = new Request.Builder().url(url).build();
        Response execute = okHttpClient.newCall(build).execute();
        String body = execute.body().string();
        JSONObject loginObject = new JSONObject(body);
        String userId = loginObject.optString("userId");
        String timestamp = loginObject.optString("timestamp");
        String token = loginObject.optString("token");
        Centrifugo centrifugo = new Centrifugo.Builder(centrifugoAddress).setUser(new User(userId, null)).setToken(new Token(token, timestamp)).build();
        final DataLock connected = new DataLock();
        final DataLock disconnected = new DataLock();
        centrifugo.setConnectionListener(new ConnectionListener(){

            public void onWebSocketOpen() {
            }

            public void onConnected() {
                connected.setData(true);
            }

            public void onDisconnected(int code, String reason, boolean remote) {
                disconnected.setData(!remote);
            }
        });
        centrifugo.connect();
        Assert.assertTrue((String)"Failed to connect to centrifugo", (boolean)((Boolean)connected.lockAndGet()));
        final DataLock channelSubscription = new DataLock();
        centrifugo.setSubscriptionListener(new SubscriptionListener(){

            public void onSubscribed(String channelName) {
                channelSubscription.setData(channelName);
            }

            public void onUnsubscribed(String channelName) {
            }

            public void onSubscriptionError(String channelName, String error) {
            }
        });
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("test-channel");
        centrifugo.subscribe(subscriptionRequest);
        Assert.assertEquals((Object)"test-channel", channelSubscription.lockAndGet());
        final DataLock messageData = new DataLock();
        centrifugo.setDataMessageListener(new DataMessageListener(){

            public void onNewDataMessage(DataMessage message) {
                messageData.setData(message);
            }
        });
        MediaType appJson = MediaType.parse((String)"application/json");
        JSONObject msg = new JSONObject();
        msg.put("input", (Object)"Hello world");
        JSONObject jsonObject = this.sendMessageJson("test-channel", msg);
        String apiSign = Signing.generateApiToken(jsonObject.toString());
        Request post = new Request.Builder().url(centrifugoApiAddress).method("POST", RequestBody.create((MediaType)appJson, (String)jsonObject.toString())).header("X-API-Sign", apiSign).header("Content-type", "application/json").build();
        Response postMessage = okHttpClient.newCall(post).execute();
        Assert.assertEquals((long)200L, (long)postMessage.code());
        DataMessage dataMessage = (DataMessage)messageData.lockAndGet();
        String input = dataMessage.getData().toString();
        Assert.assertEquals((Object)msg.toString(), (Object)input);
        msg = new JSONObject();
        msg.put("input", (Object)"Hello world#2");
        jsonObject = this.sendMessageJson("test-channel", msg);
        apiSign = Signing.generateApiToken(jsonObject.toString());
        post = new Request.Builder().url(centrifugoApiAddress).method("POST", RequestBody.create((MediaType)appJson, (String)jsonObject.toString())).header("X-API-Sign", apiSign).header("Content-type", "application/json").build();
        postMessage = okHttpClient.newCall(post).execute();
        Assert.assertEquals((long)200L, (long)postMessage.code());
        HistoryMessage historyMessage = (HistoryMessage)centrifugo.requestHistory("test-channel").blockingGet();
        Assert.assertNotNull((Object)historyMessage);
        List messages = historyMessage.getMessages();
        Assert.assertEquals((long)2L, (long)messages.size());
        JSONObject data1 = ((HistoryItem)messages.get(0)).getData();
        Assert.assertNotNull((Object)data1);
        JSONObject data2 = ((HistoryItem)messages.get(1)).getData();
        Assert.assertNotNull((Object)data2);
        Assert.assertEquals((Object)"{\"input\":\"Hello world#2\"}", (Object)data1.toString());
        Assert.assertEquals((Object)"{\"input\":\"Hello world\"}", (Object)data2.toString());
        centrifugo.disconnect();
        Assert.assertTrue((String)"Failed to properly disconnect to centrifugo", (boolean)((Boolean)disconnected.lockAndGet()));
    }

    private JSONObject sendMessageJson(String channel, JSONObject message) {
        JSONObject sendMessageJson = new JSONObject();
        try {
            sendMessageJson.put("method", (Object)"publish");
            JSONObject params = new JSONObject();
            params.put("channel", (Object)channel);
            params.put("data", (Object)message);
            sendMessageJson.put("params", (Object)params);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return sendMessageJson;
    }
}

