/*
 * Decompiled with CFR 0.152.
 */
package org.coindirect.centrifuge.java.it;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.coindirect.centrifuge.java.Centrifugo;
import org.coindirect.centrifuge.java.TestWebapp;
import org.coindirect.centrifuge.java.credentials.Token;
import org.coindirect.centrifuge.java.credentials.User;
import org.coindirect.centrifuge.java.listener.ConnectionListener;
import org.coindirect.centrifuge.java.listener.JoinLeaveListener;
import org.coindirect.centrifuge.java.listener.SubscriptionListener;
import org.coindirect.centrifuge.java.message.presence.JoinMessage;
import org.coindirect.centrifuge.java.message.presence.LeftMessage;
import org.coindirect.centrifuge.java.message.presence.PresenceMessage;
import org.coindirect.centrifuge.java.subscription.SubscriptionRequest;
import org.coindirect.centrifuge.java.util.DataLock;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.RobolectricGradleTestRunner;
import org.testcontainers.containers.GenericContainer;

@RunWith(value=RobolectricGradleTestRunner.class)
@Ignore
public class PresenceTests {
    public GenericContainer centrifugo;
    private MockWebServer mockWebServer;

    @Before
    public void beforeMethod() throws Exception {
        this.centrifugo = new GenericContainer("samvimes/centrifugo-with-web:1.3").withExposedPorts(new Integer[]{8000});
        this.centrifugo.start();
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.start();
    }

    @After
    public void afterMethod() throws Exception {
        this.mockWebServer.shutdown();
        this.centrifugo.stop();
    }

    @Test
    public void testJoined() throws Exception {
        String containerIpAddress = this.centrifugo.getContainerIpAddress() + ":" + this.centrifugo.getMappedPort(8000);
        String centrifugoAddress = "ws://" + containerIpAddress + "/connection/websocket";
        this.mockWebServer.setDispatcher((Dispatcher)new TestWebapp());
        String url = this.mockWebServer.url("/tokens").toString();
        OkHttpClient okHttpClient = new OkHttpClient();
        Request build = new Request.Builder().url(url).build();
        Response execute = okHttpClient.newCall(build).execute();
        String body = execute.body().string();
        JSONObject loginObject = new JSONObject(body);
        String userId = loginObject.optString("userId");
        String timestamp = loginObject.optString("timestamp");
        String token = loginObject.optString("token");
        Centrifugo centrifugo = new Centrifugo.Builder(centrifugoAddress).setUser(new User(userId, null)).setToken(new Token(token, timestamp)).build();
        final DataLock connected = new DataLock();
        final DataLock disconnected = new DataLock();
        centrifugo.setConnectionListener(new ConnectionListener(){

            public void onWebSocketOpen() {
            }

            public void onConnected() {
                connected.setData(true);
            }

            public void onDisconnected(int code, String reason, boolean remote) {
                disconnected.setData(!remote);
            }
        });
        centrifugo.connect();
        Assert.assertTrue((String)"Failed to connect to centrifugo", (boolean)((Boolean)connected.lockAndGet()));
        final DataLock channelSubscription = new DataLock();
        centrifugo.setSubscriptionListener(new SubscriptionListener(){

            public void onSubscribed(String channelName) {
                channelSubscription.setData(channelName);
            }

            public void onUnsubscribed(String channelName) {
            }

            public void onSubscriptionError(String channelName, String error) {
            }
        });
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("test-channel");
        centrifugo.subscribe(subscriptionRequest);
        Assert.assertEquals((Object)"test-channel", channelSubscription.lockAndGet());
        final DataLock joinMessageDataLock = new DataLock();
        centrifugo.setJoinLeaveListener(new JoinLeaveListener(){

            public void onJoin(JoinMessage joinMessage) {
                joinMessageDataLock.setData(joinMessage);
            }

            public void onLeave(LeftMessage leftMessage) {
            }
        });
        Centrifugo anotherClient = this.addAnotherClient(1);
        Assert.assertNotNull(joinMessageDataLock.lockAndGet());
        centrifugo.disconnect();
        Assert.assertTrue((String)"Failed to properly disconnect to centrifugo", (boolean)((Boolean)disconnected.lockAndGet()));
        anotherClient.disconnect();
    }

    @Test
    public void testLeft() throws Exception {
        String containerIpAddress = this.centrifugo.getContainerIpAddress() + ":" + this.centrifugo.getMappedPort(8000);
        String centrifugoAddress = "ws://" + containerIpAddress + "/connection/websocket";
        this.mockWebServer.setDispatcher((Dispatcher)new TestWebapp());
        String url = this.mockWebServer.url("/tokens").toString();
        OkHttpClient okHttpClient = new OkHttpClient();
        Request build = new Request.Builder().url(url).build();
        Response execute = okHttpClient.newCall(build).execute();
        String body = execute.body().string();
        JSONObject loginObject = new JSONObject(body);
        String userId = loginObject.optString("userId");
        String timestamp = loginObject.optString("timestamp");
        String token = loginObject.optString("token");
        Centrifugo centrifugo = new Centrifugo.Builder(centrifugoAddress).setUser(new User(userId, null)).setToken(new Token(token, timestamp)).build();
        final DataLock connected = new DataLock();
        final DataLock disconnected = new DataLock();
        centrifugo.setConnectionListener(new ConnectionListener(){

            public void onWebSocketOpen() {
            }

            public void onConnected() {
                connected.setData(true);
            }

            public void onDisconnected(int code, String reason, boolean remote) {
                disconnected.setData(!remote);
            }
        });
        centrifugo.connect();
        Assert.assertTrue((String)"Failed to connect to centrifugo", (boolean)((Boolean)connected.lockAndGet()));
        final DataLock channelSubscription = new DataLock();
        centrifugo.setSubscriptionListener(new SubscriptionListener(){

            public void onSubscribed(String channelName) {
                channelSubscription.setData(channelName);
            }

            public void onUnsubscribed(String channelName) {
            }

            public void onSubscriptionError(String channelName, String error) {
            }
        });
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("test-channel");
        centrifugo.subscribe(subscriptionRequest);
        Assert.assertEquals((Object)"test-channel", channelSubscription.lockAndGet());
        final DataLock joinMessageDataLock = new DataLock();
        final DataLock leftMessageDataLock = new DataLock();
        centrifugo.setJoinLeaveListener(new JoinLeaveListener(){

            public void onJoin(JoinMessage joinMessage) {
                joinMessageDataLock.setData(joinMessage);
            }

            public void onLeave(LeftMessage leftMessage) {
                leftMessageDataLock.setData(leftMessage);
            }
        });
        Centrifugo anotherClient = this.addAnotherClient(1);
        Assert.assertNotNull(joinMessageDataLock.lockAndGet());
        anotherClient.disconnect();
        Assert.assertNotNull(leftMessageDataLock.lockAndGet());
        centrifugo.disconnect();
        Assert.assertTrue((String)"Failed to properly disconnect to centrifugo", (boolean)((Boolean)disconnected.lockAndGet()));
    }

    @Test
    public void testPresenceRequest() throws Exception {
        String containerIpAddress = this.centrifugo.getContainerIpAddress() + ":" + this.centrifugo.getMappedPort(8000);
        String centrifugoAddress = "ws://" + containerIpAddress + "/connection/websocket";
        this.mockWebServer.setDispatcher((Dispatcher)new TestWebapp());
        String url = this.mockWebServer.url("/tokens").toString();
        OkHttpClient okHttpClient = new OkHttpClient();
        Request build = new Request.Builder().url(url).build();
        Response execute = okHttpClient.newCall(build).execute();
        String body = execute.body().string();
        JSONObject loginObject = new JSONObject(body);
        String userId = loginObject.optString("userId");
        String timestamp = loginObject.optString("timestamp");
        String token = loginObject.optString("token");
        Centrifugo centrifugo = new Centrifugo.Builder(centrifugoAddress).setUser(new User(userId, null)).setToken(new Token(token, timestamp)).build();
        final DataLock connected = new DataLock();
        final DataLock disconnected = new DataLock();
        centrifugo.setConnectionListener(new ConnectionListener(){

            public void onWebSocketOpen() {
            }

            public void onConnected() {
                connected.setData(true);
            }

            public void onDisconnected(int code, String reason, boolean remote) {
                disconnected.setData(!remote);
            }
        });
        centrifugo.connect();
        Assert.assertTrue((String)"Failed to connect to centrifugo", (boolean)((Boolean)connected.lockAndGet()));
        final DataLock channelSubscription = new DataLock();
        centrifugo.setSubscriptionListener(new SubscriptionListener(){

            public void onSubscribed(String channelName) {
                channelSubscription.setData(channelName);
            }

            public void onUnsubscribed(String channelName) {
            }

            public void onSubscriptionError(String channelName, String error) {
            }
        });
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("test-channel");
        centrifugo.subscribe(subscriptionRequest);
        Assert.assertEquals((Object)"test-channel", channelSubscription.lockAndGet());
        final DataLock joinMessageDataLock = new DataLock();
        final DataLock leftMessageDataLock = new DataLock();
        centrifugo.setJoinLeaveListener(new JoinLeaveListener(){

            public void onJoin(JoinMessage joinMessage) {
                joinMessageDataLock.setData(joinMessage);
            }

            public void onLeave(LeftMessage leftMessage) {
                leftMessageDataLock.setData(leftMessage);
            }
        });
        Centrifugo anotherClient = this.addAnotherClient(1);
        Assert.assertNotNull(joinMessageDataLock.lockAndGet());
        PresenceMessage presenceMessage = (PresenceMessage)centrifugo.requestPresence("test-channel").blockingGet();
        Assert.assertEquals((long)2L, (long)presenceMessage.getUserList().size());
        anotherClient.disconnect();
        Assert.assertNotNull(leftMessageDataLock.lockAndGet());
        centrifugo.disconnect();
        Assert.assertTrue((String)"Failed to properly disconnect to centrifugo", (boolean)((Boolean)disconnected.lockAndGet()));
    }

    private JSONObject sendMessageJson(String channel, JSONObject message) {
        JSONObject sendMessageJson = new JSONObject();
        try {
            sendMessageJson.put("method", (Object)"publish");
            JSONObject params = new JSONObject();
            params.put("channel", (Object)channel);
            params.put("data", (Object)message);
            sendMessageJson.put("params", (Object)params);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return sendMessageJson;
    }

    private Centrifugo addAnotherClient(int num) throws IOException, JSONException {
        String containerIpAddress = this.centrifugo.getContainerIpAddress() + ":" + this.centrifugo.getMappedPort(8000);
        String centrifugoAddress = "ws://" + containerIpAddress + "/connection/websocket";
        OkHttpClient okHttpClient = new OkHttpClient();
        String url = this.mockWebServer.url("/tokens").toString();
        Request build = new Request.Builder().url(url).header("num", "" + num).build();
        Response execute = okHttpClient.newCall(build).execute();
        String body = execute.body().string();
        JSONObject loginObject = new JSONObject(body);
        String userId = loginObject.optString("userId");
        String timestamp = loginObject.optString("timestamp");
        String token = loginObject.optString("token");
        Centrifugo centrifugo = new Centrifugo.Builder(centrifugoAddress).setUser(new User(userId, null)).setToken(new Token(token, timestamp)).build();
        final DataLock connected = new DataLock();
        final DataLock disconnected = new DataLock();
        centrifugo.setConnectionListener(new ConnectionListener(){

            public void onWebSocketOpen() {
            }

            public void onConnected() {
                connected.setData(true);
            }

            public void onDisconnected(int code, String reason, boolean remote) {
                disconnected.setData(!remote);
            }
        });
        centrifugo.connect();
        Assert.assertTrue((String)"Failed to connect to centrifugo", (boolean)((Boolean)connected.lockAndGet()));
        final DataLock channelSubscription = new DataLock();
        centrifugo.setSubscriptionListener(new SubscriptionListener(){

            public void onSubscribed(String channelName) {
                channelSubscription.setData(channelName);
            }

            public void onUnsubscribed(String channelName) {
            }

            public void onSubscriptionError(String channelName, String error) {
            }
        });
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("test-channel");
        centrifugo.subscribe(subscriptionRequest);
        Assert.assertEquals((Object)"test-channel", channelSubscription.lockAndGet());
        return centrifugo;
    }
}

