/*
 * Decompiled with CFR 0.152.
 */
package org.coindirect.centrifuge.java;

import java.net.URI;
import java.nio.channels.NotYetConnectedException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.coindirect.centrifuge.java.async.Future;
import org.coindirect.centrifuge.java.config.ReconnectConfig;
import org.coindirect.centrifuge.java.credentials.Token;
import org.coindirect.centrifuge.java.credentials.User;
import org.coindirect.centrifuge.java.listener.ConnectionListener;
import org.coindirect.centrifuge.java.listener.DataMessageListener;
import org.coindirect.centrifuge.java.listener.DownstreamMessageListener;
import org.coindirect.centrifuge.java.listener.JoinLeaveListener;
import org.coindirect.centrifuge.java.listener.SubscriptionListener;
import org.coindirect.centrifuge.java.message.DataMessage;
import org.coindirect.centrifuge.java.message.DownstreamMessage;
import org.coindirect.centrifuge.java.message.SubscribeMessage;
import org.coindirect.centrifuge.java.message.history.HistoryMessage;
import org.coindirect.centrifuge.java.message.presence.JoinMessage;
import org.coindirect.centrifuge.java.message.presence.LeftMessage;
import org.coindirect.centrifuge.java.message.presence.PresenceMessage;
import org.coindirect.centrifuge.java.subscription.ActiveSubscription;
import org.coindirect.centrifuge.java.subscription.SubscriptionRequest;
import org.coindirect.centrifuge.java.subscription.UnsubscribeRequest;
import org.java_websocket.client.DefaultSSLWebSocketClientFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Centrifugo {
    private static final Logger Log = LoggerFactory.getLogger(Centrifugo.class);
    private static final String TAG = "CentrifugoClient";
    private static final String PRIVATE_CHANNEL_PREFIX = "$";
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_ERROR = 1;
    private static final int STATE_CONNECTED = 2;
    private static final int STATE_DISCONNECTING = 3;
    private static final int STATE_CONNECTING = 4;
    private String wsURI;
    private String userId;
    private String clientId;
    private String token;
    private String tokenTimestamp;
    private String info;
    @Nullable
    private ReconnectConfig reconnectConfig;
    private Client client;
    private int state = 0;
    private Map<String, ActiveSubscription> subscribedChannels = new HashMap<String, ActiveSubscription>();
    private List<SubscriptionRequest> channelsToSubscribe = new ArrayList<SubscriptionRequest>();
    @Nullable
    private DataMessageListener dataMessageListener;
    @Nullable
    private ConnectionListener connectionListener;
    @Nullable
    private SubscriptionListener subscriptionListener;
    @Nullable
    private JoinLeaveListener joinLeaveListener;
    private Map<String, DownstreamMessageListener> commandListeners = new HashMap<String, DownstreamMessageListener>();

    protected Centrifugo(String wsURI, String userId, String clientId, String token, String tokenTimestamp, String info) {
        this.wsURI = wsURI;
        this.userId = userId;
        this.clientId = clientId;
        this.token = token;
        this.tokenTimestamp = tokenTimestamp;
        this.info = info;
    }

    public void connect() {
        if (this.client == null || this.state != 2 && this.state != 4) {
            this.state = 4;
            URI uri = URI.create(this.wsURI);
            this.client = new Client(uri, (Draft)new Draft_17());
            if (uri.getScheme().equals("wss")) {
                SSLContext sslContext = null;
                try {
                    sslContext = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    Log.debug("Failed to start connection: " + e.getMessage());
                    if (this.connectionListener != null) {
                        this.connectionListener.onDisconnected(-1, e.getMessage(), true);
                    }
                    return;
                }
                this.client.setWebSocketFactory((WebSocketClient.WebSocketClientFactory)new DefaultSSLWebSocketClientFactory(sslContext));
            }
            this.client.start();
        }
    }

    public void disconnect() {
        if (this.client != null && this.state == 2) {
            this.state = 3;
            this.client.stop();
        }
    }

    @Nullable
    public JoinLeaveListener getJoinLeaveListener() {
        return this.joinLeaveListener;
    }

    public void setJoinLeaveListener(@Nullable JoinLeaveListener joinLeaveListener) {
        this.joinLeaveListener = joinLeaveListener;
    }

    public void setSubscriptionListener(@Nullable SubscriptionListener subscriptionListener) {
        this.subscriptionListener = subscriptionListener;
    }

    public void setConnectionListener(@Nullable ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public void setDataMessageListener(@Nullable DataMessageListener dataMessageListener) {
        this.dataMessageListener = dataMessageListener;
    }

    protected void onOpen(ServerHandshake handshakeData) {
        this.onWebSocketOpen();
        try {
            JSONObject jsonObject = new JSONObject();
            this.fillConnectionJSON((Handshakedata)handshakeData, jsonObject);
            JSONArray messages = new JSONArray();
            messages.put((Object)jsonObject);
            this.client.send(messages.toString());
        }
        catch (JSONException e) {
            this.logErrorWhen("during connection", (Exception)((Object)e));
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        Log.info("onClose: " + code + ", " + reason + ", " + remote);
        this.onDisconnected(code, reason, remote);
    }

    protected void fillConnectionJSON(Handshakedata handshakeData, JSONObject jsonObject) throws JSONException {
        jsonObject.put("uid", (Object)UUID.randomUUID().toString());
        jsonObject.put("method", (Object)"connect");
        JSONObject params = new JSONObject();
        params.put("user", (Object)this.userId);
        params.put("timestamp", (Object)this.tokenTimestamp);
        params.put("info", (Object)this.info);
        params.put("token", (Object)this.token);
        jsonObject.put("params", (Object)params);
    }

    protected void onWebSocketOpen() {
        if (this.connectionListener != null) {
            this.connectionListener.onWebSocketOpen();
        }
    }

    protected void onConnected() {
        if (this.connectionListener != null) {
            this.connectionListener.onConnected();
        }
    }

    protected void onDisconnected(int code, String reason, boolean remote) {
        this.state = 0;
        for (ActiveSubscription activeSubscription : this.subscribedChannels.values()) {
            activeSubscription.setConnected(false);
        }
        if (this.connectionListener != null) {
            this.connectionListener.onDisconnected(code, reason, remote);
        }
        if (remote && this.reconnectConfig != null && this.reconnectConfig.shouldReconnect()) {
            this.reconnectConfig.incReconnectCount();
            long reconnectDelay = this.reconnectConfig.getReconnectDelay();
            this.scheduleReconnect(reconnectDelay);
        }
    }

    public void logErrorWhen(String when, Exception ex) {
        Log.error("Error occured  " + when + ": ", (Throwable)ex);
    }

    public void onError(Exception ex) {
        Log.error("onError: ", (Throwable)ex);
        this.state = 1;
    }

    protected void onSubscriptionError(@Nullable String subscriptionError) {
        if (this.subscriptionListener != null) {
            this.subscriptionListener.onSubscriptionError(null, subscriptionError);
        }
    }

    protected void onSubscribedToChannel(@Nonnull String channelName) {
        if (this.subscriptionListener != null) {
            this.subscriptionListener.onSubscribed(channelName);
        }
    }

    protected void onNewMessage(DataMessage dataMessage) {
        String uuid = dataMessage.getUUID();
        ActiveSubscription activeSubscription = this.subscribedChannels.get(dataMessage.getChannel());
        if (activeSubscription != null) {
            activeSubscription.updateLastMessage(uuid);
        }
        if (this.dataMessageListener != null) {
            this.dataMessageListener.onNewDataMessage(dataMessage);
        }
    }

    protected void onLeftMessage(LeftMessage leftMessage) {
        if (this.joinLeaveListener != null) {
            this.joinLeaveListener.onLeave(leftMessage);
        }
    }

    protected void onJoinMessage(JoinMessage joinMessage) {
        if (this.joinLeaveListener != null) {
            this.joinLeaveListener.onJoin(joinMessage);
        }
    }

    public void subscribe(@Nonnull SubscriptionRequest subscriptionRequest) {
        this.subscribe(subscriptionRequest, null);
    }

    public void subscribe(final SubscriptionRequest subscriptionRequest, @Nullable String lastMessageId) {
        if (this.state != 2) {
            this.channelsToSubscribe.add(subscriptionRequest);
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            String uuid = this.fillSubscriptionJSON(jsonObject, subscriptionRequest, lastMessageId);
            this.commandListeners.put(uuid, new DownstreamMessageListener(){

                @Override
                public void onDownstreamMessage(DownstreamMessage message) {
                    JSONArray recoveredMessages;
                    SubscribeMessage subscribeMessage = (SubscribeMessage)message;
                    String subscriptionError = subscribeMessage.getError();
                    if (subscriptionError != null) {
                        Centrifugo.this.onSubscriptionError(subscriptionError);
                        return;
                    }
                    String channelName = subscribeMessage.getChannel();
                    Boolean status = subscribeMessage.getStatus();
                    if (status != null && status.booleanValue() && channelName != null) {
                        ActiveSubscription activeSubscription;
                        String channel = subscriptionRequest.getChannel();
                        if (Centrifugo.this.subscribedChannels.containsKey(channel)) {
                            activeSubscription = (ActiveSubscription)Centrifugo.this.subscribedChannels.get(channel);
                        } else {
                            activeSubscription = new ActiveSubscription(subscriptionRequest);
                            Centrifugo.this.subscribedChannels.put(channel, activeSubscription);
                        }
                        activeSubscription.setConnected(true);
                        Centrifugo.this.onSubscribedToChannel(channelName);
                    }
                    if ((recoveredMessages = subscribeMessage.getRecoveredMessages()) != null) {
                        for (int i = 0; i < recoveredMessages.length(); ++i) {
                            JSONObject messageObj = recoveredMessages.optJSONObject(i);
                            DataMessage dataMessage = DataMessage.fromBody(messageObj);
                            Centrifugo.this.onNewMessage(dataMessage);
                        }
                    }
                }
            });
            JSONArray messages = new JSONArray();
            messages.put((Object)jsonObject);
            this.client.send(messages.toString());
        }
        catch (JSONException e) {
            this.logErrorWhen("during subscription", (Exception)((Object)e));
        }
    }

    public void unsubscribe(UnsubscribeRequest unsubscribeRequest) {
        if (this.state != 2) {
            for (SubscriptionRequest request : this.channelsToSubscribe) {
                if (!request.getChannel().equals(unsubscribeRequest.getChannel())) continue;
                this.channelsToSubscribe.remove(request);
            }
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            String uuid = this.fillUnsubscribeJson(jsonObject, unsubscribeRequest);
            JSONArray messages = new JSONArray();
            messages.put((Object)jsonObject);
            this.client.send(messages.toString());
        }
        catch (JSONException e) {
            this.logErrorWhen("during unsubscribe", (Exception)((Object)e));
        }
    }

    protected String fillSubscriptionJSON(JSONObject jsonObject, SubscriptionRequest subscriptionRequest, @Nullable String lastMessageId) throws JSONException {
        String uuid = UUID.randomUUID().toString();
        jsonObject.put("uid", (Object)uuid);
        jsonObject.put("method", (Object)"subscribe");
        JSONObject params = new JSONObject();
        String channel = subscriptionRequest.getChannel();
        params.put("channel", (Object)channel);
        if (channel.startsWith(PRIVATE_CHANNEL_PREFIX)) {
            params.put("sign", (Object)subscriptionRequest.getChannelToken());
            params.put("client", (Object)this.clientId);
            params.put("info", (Object)subscriptionRequest.getInfo());
        }
        if (lastMessageId != null) {
            params.put("last", (Object)lastMessageId);
            params.put("recover", true);
        }
        jsonObject.put("params", (Object)params);
        return uuid;
    }

    protected String fillUnsubscribeJson(JSONObject jsonObject, UnsubscribeRequest unsubscribeRequest) throws JSONException {
        String uuid = UUID.randomUUID().toString();
        jsonObject.put("uid", (Object)uuid);
        jsonObject.put("method", (Object)"unsubscribe");
        JSONObject params = new JSONObject();
        String channel = unsubscribeRequest.getChannel();
        params.put("channel", (Object)channel);
        jsonObject.put("params", (Object)params);
        return uuid;
    }

    protected void onMessage(@Nonnull JSONObject message) {
        String method = message.optString("method", "");
        if (method.equals("connect")) {
            JSONObject body = message.optJSONObject("body");
            if (body != null) {
                this.clientId = body.optString("client");
            }
            this.state = 2;
            for (SubscriptionRequest subscriptionRequest : this.channelsToSubscribe) {
                this.subscribe(subscriptionRequest);
            }
            this.channelsToSubscribe.clear();
            for (ActiveSubscription activeSubscription : this.subscribedChannels.values()) {
                this.subscribe(activeSubscription.getInitialRequest(), activeSubscription.getLastMessageId());
            }
            this.onConnected();
            return;
        }
        if (method.equals("subscribe")) {
            SubscribeMessage subscribeMessage = new SubscribeMessage(message);
            String uuid = subscribeMessage.getRequestUUID();
            DownstreamMessageListener listener = this.commandListeners.get(uuid);
            if (listener != null) {
                listener.onDownstreamMessage(subscribeMessage);
            }
            return;
        }
        if (method.equals("unsubscribe")) {
            return;
        }
        if (method.equals("join")) {
            JoinMessage joinMessage = new JoinMessage(message);
            this.onJoinMessage(joinMessage);
            return;
        }
        if (method.equals("leave")) {
            LeftMessage leftMessage = new LeftMessage(message);
            this.onLeftMessage(leftMessage);
            return;
        }
        if (method.equals("presence")) {
            PresenceMessage presenceMessage = new PresenceMessage(message);
            String uuid = presenceMessage.getRequestUUID();
            DownstreamMessageListener listener = this.commandListeners.get(uuid);
            if (listener != null) {
                listener.onDownstreamMessage(presenceMessage);
            }
            return;
        }
        if (method.equals("history")) {
            HistoryMessage historyMessage = new HistoryMessage(message);
            String uuid = historyMessage.getRequestUUID();
            DownstreamMessageListener listener = this.commandListeners.get(uuid);
            if (listener != null) {
                listener.onDownstreamMessage(historyMessage);
            }
            return;
        }
        if (method.equals("disconnect")) {
            if (this.connectionListener != null) {
                DownstreamMessage downstreamMessage = new DownstreamMessage(message);
                String reason = downstreamMessage.getBody().optString("reason");
                this.connectionListener.onDisconnected(-1, reason, true);
            }
            return;
        }
        DataMessage dataMessage = new DataMessage(message);
        this.onNewMessage(dataMessage);
    }

    public Future<HistoryMessage> requestHistory(String channelName) {
        JSONObject jsonObject = new JSONObject();
        String commandId = UUID.randomUUID().toString();
        try {
            jsonObject.put("uid", (Object)commandId);
            jsonObject.put("method", (Object)"history");
            JSONObject params = new JSONObject();
            params.put("channel", (Object)channelName);
            jsonObject.put("params", (Object)params);
        }
        catch (JSONException params) {
            // empty catch block
        }
        final Future<HistoryMessage> historyMessage = new Future<HistoryMessage>();
        historyMessage.setRestrictedThread(this.client.getClientThread());
        this.commandListeners.put(commandId, new DownstreamMessageListener(){

            @Override
            public void onDownstreamMessage(DownstreamMessage message) {
                historyMessage.setData((HistoryMessage)message);
            }
        });
        this.client.send(jsonObject.toString());
        return historyMessage;
    }

    public Future<PresenceMessage> requestPresence(String channelName) {
        JSONObject jsonObject = new JSONObject();
        String commandId = UUID.randomUUID().toString();
        try {
            jsonObject.put("uid", (Object)commandId);
            jsonObject.put("method", (Object)"presence");
            JSONObject params = new JSONObject();
            params.put("channel", (Object)channelName);
            jsonObject.put("params", (Object)params);
        }
        catch (JSONException params) {
            // empty catch block
        }
        final Future<PresenceMessage> presenceMessage = new Future<PresenceMessage>();
        presenceMessage.setRestrictedThread(this.client.getClientThread());
        this.commandListeners.put(commandId, new DownstreamMessageListener(){

            @Override
            public void onDownstreamMessage(DownstreamMessage message) {
                presenceMessage.setData((PresenceMessage)message);
            }
        });
        this.client.send(jsonObject.toString());
        return presenceMessage;
    }

    private void scheduleReconnect(@Nonnegative long delay) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Centrifugo.this.connect();
                timer.cancel();
                this.cancel();
            }
        }, delay);
    }

    public void setReconnectConfig(@Nullable ReconnectConfig reconnectConfig) {
        this.reconnectConfig = reconnectConfig;
    }

    public static class Builder {
        @Nonnull
        private String wsURI;
        private User user;
        private Token token;
        @Nullable
        private String info;
        @Nullable
        private ReconnectConfig reconnectConfig;

        public Builder(@Nonnull String wsURI) {
            this.wsURI = wsURI;
        }

        public Builder setToken(@Nonnull Token token) {
            this.token = token;
            return this;
        }

        public Builder setUser(@Nonnull User user) {
            this.user = user;
            return this;
        }

        public Builder setInfo(@Nullable String info) {
            this.info = info;
            return this;
        }

        public Builder setReconnectConfig(@Nullable ReconnectConfig reconnectConfig) {
            this.reconnectConfig = reconnectConfig;
            return this;
        }

        public Centrifugo build() {
            if (this.user == null) {
                throw new NullPointerException("user info not provided");
            }
            if (this.token == null) {
                throw new NullPointerException("token not provided");
            }
            Centrifugo centrifugo = new Centrifugo(this.wsURI, this.user.getUser(), this.user.getClient(), this.token.getToken(), this.token.getTokenTimestamp(), this.info);
            centrifugo.setReconnectConfig(this.reconnectConfig);
            return centrifugo;
        }
    }

    private class Client
    extends WebSocketClient {
        private Thread clientThread;
        private ExecutorService executor;

        public Client(URI serverURI, Draft draft) {
            super(serverURI, draft);
            this.executor = Executors.newSingleThreadExecutor();
            this.clientThread = new Thread((Runnable)((Object)this), "Centrifugo");
        }

        public Thread getClientThread() {
            return this.clientThread;
        }

        public void onOpen(ServerHandshake handshakedata) {
            Centrifugo.this.onOpen(handshakedata);
        }

        public void onMessage(String message) {
            try {
                Object object = new JSONTokener(message).nextValue();
                if (object instanceof JSONObject) {
                    JSONObject messageObj = (JSONObject)object;
                    Centrifugo.this.onMessage(messageObj);
                } else if (object instanceof JSONArray) {
                    JSONArray messageArray = new JSONArray(message);
                    for (int i = 0; i < messageArray.length(); ++i) {
                        JSONObject messageObj = messageArray.optJSONObject(i);
                        Centrifugo.this.onMessage(messageObj);
                    }
                }
            }
            catch (JSONException e) {
                Centrifugo.this.logErrorWhen("during message handling", (Exception)((Object)e));
            }
        }

        public void onClose(int code, String reason, boolean remote) {
            Centrifugo.this.onClose(code, reason, remote);
        }

        public void onError(Exception ex) {
            Centrifugo.this.onError(ex);
            try {
                this.closeBlocking();
            }
            catch (InterruptedException e) {
                Log.error("Error while closing WS connection: " + e.getMessage(), (Throwable)e);
            }
        }

        public void start() {
            this.clientThread.start();
        }

        public void stop() {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Client.this.closeBlocking();
                    }
                    catch (InterruptedException e) {
                        Log.error("Error while closing WS connection: " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }

        public void send(final byte[] data) throws NotYetConnectedException {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Client.super.send(data);
                }
            });
        }

        public void send(final String text) throws NotYetConnectedException {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Client.super.send(text);
                }
            });
        }
    }
}

