/*
 * Decompiled with CFR 0.152.
 */
package org.coindirect.centrifuge.java.async;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.coindirect.centrifuge.java.async.DeadLockException;
import org.coindirect.centrifuge.java.listener.FutureListener;

public class Future<T> {
    @Nullable
    private FutureListener<T> futureListener;
    private volatile T data;
    private Thread restrictedThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T blockingGet(long timeout, @Nullable TimeUnit timeUnit) {
        if (Thread.currentThread() == this.restrictedThread) {
            throw new DeadLockException("You are trying to block the thread, which will process request. This results to a deadlock.");
        }
        if (this.data == null) {
            Future future = this;
            synchronized (future) {
                while (this.data == null) {
                    try {
                        if (timeout == -1L) {
                            this.wait();
                            continue;
                        }
                        TimeUnit tm = timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit;
                        long millis = tm.toMillis(timeout);
                        this.wait(millis);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }
        return this.data;
    }

    @Nullable
    public T blockingGet() {
        return this.blockingGet(-1L, null);
    }

    public void setRestrictedThread(Thread thread) {
        this.restrictedThread = thread;
    }

    public void then(FutureListener<T> futureListener) {
        this.futureListener = futureListener;
    }

    public synchronized void setData(T data) {
        this.data = data;
        if (this.futureListener != null) {
            this.futureListener.onData(data);
        }
        this.notifyAll();
    }
}

