/*
 * Decompiled with CFR 0.152.
 */
package org.coindirect.centrifuge.java.config;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;

public class ReconnectConfig {
    private int maxReconnectCount;
    private long reconnectDelay;
    private int curReconnectCount = 0;

    public ReconnectConfig(int maxReconnectCount, @Nonnegative long reconnectDelay, TimeUnit timeUnit) {
        this.maxReconnectCount = maxReconnectCount;
        this.reconnectDelay = timeUnit.toMillis(reconnectDelay);
    }

    public int getMaxReconnectCount() {
        return this.maxReconnectCount;
    }

    public void setMaxReconnectCount(int maxReconnectCount) {
        this.maxReconnectCount = maxReconnectCount;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public void incReconnectCount() {
        ++this.curReconnectCount;
    }

    public boolean shouldReconnect() {
        return this.curReconnectCount < this.maxReconnectCount;
    }
}

