/*
 * Decompiled with CFR 0.152.
 */
package org.coindirect.centrifuge.java.message;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.coindirect.centrifuge.java.credentials.Info;
import org.coindirect.centrifuge.java.credentials.User;
import org.coindirect.centrifuge.java.message.DownstreamMessage;
import org.json.JSONObject;

public class DataMessage
extends DownstreamMessage {
    private String data;
    @Nonnull
    private String UUID;
    @Nonnull
    private String channel;
    @Nullable
    private Info info;
    @Nonnull
    private Date timestamp;

    public static DataMessage fromBody(JSONObject jsonObject) {
        DataMessage dataMessage = new DataMessage();
        dataMessage.setBody(jsonObject);
        dataMessage.setOriginalMessage(jsonObject);
        dataMessage.init(jsonObject);
        return dataMessage;
    }

    public DataMessage() {
    }

    public DataMessage(JSONObject jsonObject) {
        super(jsonObject);
        this.init(this.body);
    }

    private void init(@Nonnull JSONObject body) {
        Object dataObj = body.opt("data");
        if (dataObj != null) {
            this.data = dataObj.toString();
        }
        this.UUID = body.optString("uid");
        this.channel = body.optString("channel");
        JSONObject infoJSON = body.optJSONObject("info");
        if (infoJSON != null) {
            String userString = infoJSON.optString("user");
            String clientString = infoJSON.optString("client");
            User user = new User(userString, clientString);
            JSONObject defaultInfo = infoJSON.optJSONObject("default_info");
            JSONObject channelInfo = infoJSON.optJSONObject("channel_info");
            this.info = new Info(user, defaultInfo, channelInfo);
        }
    }

    public String getData() {
        return this.data;
    }

    @Nonnull
    public String getChannel() {
        return this.channel;
    }

    @Nullable
    public Info getInfo() {
        return this.info;
    }

    @Nonnull
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public String getUUID() {
        return this.UUID;
    }
}

