/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mavennatives.nativedependencies;

import com.googlecode.mavennatives.nativedependencies.JarUnpackable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="copy", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
final class CopyNativesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/natives")
    private File nativesTargetDir;
    @Parameter(defaultValue="false")
    private boolean separateDirs;
    @Parameter
    private List<String> platforms;
    @Component
    private JarUnpackable jarUnpacker;
    @Component
    private BuildContext buildContext;
    private static final Log LOG = new SystemStreamLog();

    CopyNativesMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean platformsActive;
            this.getLog().info((CharSequence)("Saving natives in " + this.nativesTargetDir));
            if (this.separateDirs) {
                this.getLog().info((CharSequence)"Storing artifacts in separate dirs according to classifier");
            }
            boolean bl = platformsActive = this.platforms != null && !this.platforms.isEmpty();
            if (platformsActive) {
                this.getLog().info((CharSequence)String.format("Only copying the following platforms: %s", this.platforms));
            } else {
                this.getLog().info((CharSequence)"Copying all platforms.");
            }
            Set artifacts = this.project.getArtifacts();
            boolean wereNativesTargetDirectoriesMade = this.nativesTargetDir.mkdirs();
            if (!wereNativesTargetDirectoriesMade) {
                this.getLog().info((CharSequence)("Unable to create directories(may already have existed): " + this.nativesTargetDir));
            }
            for (Artifact artifact : artifacts) {
                boolean wereArtifactDirectoriesMade;
                String classifier = artifact.getClassifier();
                if (classifier == null || !classifier.startsWith("natives-")) continue;
                String platform = classifier.substring("natives-".length());
                if (platformsActive && !this.platforms.contains(platform)) {
                    this.getLog().info((CharSequence)String.format("Skipping other platform: G:%s - A:%s - C:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier()));
                    continue;
                }
                this.getLog().info((CharSequence)String.format("G:%s - A:%s - C:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier()));
                File artifactDir = this.nativesTargetDir;
                if (this.separateDirs && !(wereArtifactDirectoriesMade = (artifactDir = new File(this.nativesTargetDir, platform)).mkdirs())) {
                    this.getLog().info((CharSequence)("Unable to create directories(may already have existed): " + this.nativesTargetDir));
                }
                this.jarUnpacker.copyJarContent(artifact.getFile(), artifactDir);
            }
            this.buildContext.refresh(this.nativesTargetDir);
        }
        catch (IOException e) {
            try {
                StringWriter sw = new StringWriter();
                Throwable throwable = null;
                try {
                    try {
                        PrintWriter pw = new PrintWriter(sw);
                        Throwable throwable2 = null;
                        try {
                            try {
                                e.printStackTrace(pw);
                                throw new MojoFailureException("IllegalStateException prevented copying of natives: " + ((Object)sw).toString(), (Throwable)e);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (pw != null) {
                                if (throwable2 != null) {
                                    try {
                                        ((Writer)pw).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((Writer)pw).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable pw) {
                        throwable = pw;
                        throw pw;
                    }
                }
                catch (Throwable throwable6) {
                    if (sw != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)sw).close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            ((Writer)sw).close();
                        }
                    }
                    throw throwable6;
                }
            }
            catch (IOException ioe) {
                throw new MojoFailureException("IOException prevented copying of natives: " + ioe.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (NullPointerException e) {
            try {
                StringWriter sw = new StringWriter();
                Throwable throwable = null;
                try {
                    try {
                        PrintWriter pw = new PrintWriter(sw);
                        Throwable throwable8 = null;
                        try {
                            try {
                                e.printStackTrace(pw);
                                throw new MojoFailureException("NullPointerException prevented copying of natives: " + ((Object)sw).toString(), (Throwable)e);
                            }
                            catch (Throwable throwable9) {
                                throwable8 = throwable9;
                                throw throwable9;
                            }
                        }
                        catch (Throwable throwable10) {
                            if (pw != null) {
                                if (throwable8 != null) {
                                    try {
                                        ((Writer)pw).close();
                                    }
                                    catch (Throwable throwable11) {
                                        throwable8.addSuppressed(throwable11);
                                    }
                                } else {
                                    ((Writer)pw).close();
                                }
                            }
                            throw throwable10;
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable = throwable12;
                        throw throwable12;
                    }
                }
                catch (Throwable throwable13) {
                    if (sw != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)sw).close();
                            }
                            catch (Throwable throwable14) {
                                throwable.addSuppressed(throwable14);
                            }
                        } else {
                            ((Writer)sw).close();
                        }
                    }
                    throw throwable13;
                }
            }
            catch (IOException ioe) {
                throw new MojoFailureException("IOException prevented copying of natives: " + ioe.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (SecurityException e) {
            throw new MojoFailureException("SecurityException prevented copying of natives.", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoFailureException("Exception prevented copying of natives: " + e.toString(), (Throwable)e);
        }
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    public void setNativesTargetDir(File nativesTargetDir2) {
        this.nativesTargetDir = nativesTargetDir2;
    }

    public void setJarUnpacker(JarUnpackable jarUnpacker) {
        this.jarUnpacker = jarUnpacker;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(List<String> platforms) {
        this.platforms = platforms;
    }
}

