/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mavennatives.nativedependencies;

import com.googlecode.mavennatives.nativedependencies.JarUnpackable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=JarUnpackable.class)
public class JarUnpacker
implements JarUnpackable {
    private static final Log log = new SystemStreamLog();
    private static final List<String> IGNORED_FILES = new ArrayList<String>(){
        {
            this.add("META-INF");
            this.add("MANIFEST.MF");
        }
    };

    @Override
    public void copyJarContent(File jarPath, File targetDir) throws IOException {
        log.info((CharSequence)("Copying natives from " + jarPath.getName()));
        JarFile jar = new JarFile(jarPath);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            boolean wereParentFileDirectoriesMade;
            JarEntry file = entries.nextElement();
            File f = new File(targetDir, file.getName());
            if (IGNORED_FILES.contains(f.getName())) continue;
            log.info((CharSequence)("Copying native - " + file.getName()));
            File parentFile = f.getParentFile();
            if (!parentFile.exists() && !(wereParentFileDirectoriesMade = parentFile.mkdirs())) {
                throw new IOException("Unable to create directories.");
            }
            if (file.isDirectory() && !f.exists()) {
                boolean wereFileDirectoriesMade = f.mkdir();
                if (wereFileDirectoriesMade) continue;
                throw new IOException("Unable to create directories.");
            }
            InputStream is = jar.getInputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream fos = new FileOutputStream(f);
                Throwable throwable2 = null;
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
    }
}

