/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import com.google.auto.service.AutoService;
import fxlauncher.FXManifest;
import fxlauncher.UIProvider;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

@AutoService(value={UIProvider.class})
public class DefaultUIProvider
implements UIProvider {
    private ProgressBar progressBar;

    @Override
    public Parent createLoader() {
        StackPane root = new StackPane(new Node[]{new ProgressIndicator()});
        root.setPrefSize(200.0, 80.0);
        root.setPadding(new Insets(10.0));
        return root;
    }

    @Override
    public Parent createUpdater(FXManifest manifest) {
        this.progressBar = new ProgressBar();
        this.progressBar.setStyle(manifest.progressBarStyle);
        Label label = new Label(manifest.updateText);
        label.setStyle(manifest.updateLabelStyle);
        VBox wrapper = new VBox(new Node[]{label, this.progressBar});
        wrapper.setStyle(manifest.wrapperStyle);
        return wrapper;
    }

    @Override
    public void updateProgress(double progress) {
        this.progressBar.setProgress(progress);
    }

    @Override
    public void init(Stage stage) {
    }
}

