/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.AbstractLauncher;
import fxlauncher.Constants;
import fxlauncher.DefaultUIProvider;
import fxlauncher.FXManifest;
import fxlauncher.LauncherParams;
import fxlauncher.UIProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class Launcher
extends Application {
    private static final Logger log = Logger.getLogger("Launcher");
    private Application app;
    private Stage primaryStage;
    private Stage stage;
    private UIProvider uiProvider;
    private StackPane root;
    private final AbstractLauncher<Application> superLauncher = new AbstractLauncher<Application>(){

        @Override
        protected Application.Parameters getParameters() {
            return Launcher.this.getParameters();
        }

        @Override
        protected void updateProgress(double progress) {
            Platform.runLater(() -> Launcher.this.uiProvider.updateProgress(progress));
        }

        @Override
        protected void createApplication(Class<Application> appClass) {
            Launcher.this.runAndWait(() -> {
                try {
                    if (!Application.class.isAssignableFrom(appClass)) {
                        throw new IllegalArgumentException(String.format(Constants.getString("Error.Application.Create.1"), appClass));
                    }
                    Launcher.this.app = (Application)appClass.newInstance();
                }
                catch (Throwable t) {
                    this.reportError(Constants.getString("Error.Application.Create.2"), t);
                }
            });
        }

        @Override
        protected void reportError(String title, Throwable error) {
            log.log(Level.WARNING, title, error);
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(title);
                alert.setHeaderText(String.format(Constants.getString("Error.Alert.Header"), title, System.getProperty("java.io.tmpdir")));
                alert.getDialogPane().setPrefWidth(600.0);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(out);
                error.printStackTrace(writer);
                writer.close();
                TextArea text = new TextArea(out.toString());
                alert.getDialogPane().setContent((Node)text);
                alert.showAndWait();
                Platform.exit();
            });
        }

        @Override
        protected void setupClassLoader(ClassLoader classLoader) {
            FXMLLoader.setDefaultClassLoader((ClassLoader)classLoader);
            Platform.runLater(() -> Thread.currentThread().setContextClassLoader(classLoader));
        }
    };

    public static FXManifest checkForUpdate() throws IOException {
        if (AbstractLauncher.manifest == null) {
            return null;
        }
        FXManifest manifest = FXManifest.load(URI.create(AbstractLauncher.manifest.uri + "/app.xml"));
        return manifest.equals(AbstractLauncher.manifest) ? null : manifest;
    }

    public void init() throws Exception {
        Iterator<UIProvider> providers = ServiceLoader.load(UIProvider.class).iterator();
        providers.forEachRemaining(p -> {
            this.uiProvider = p;
        });
        if (this.uiProvider == null) {
            this.uiProvider = new DefaultUIProvider();
        }
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.stage = new Stage(StageStyle.UNDECORATED);
        this.root = new StackPane();
        boolean[] filesUpdated = new boolean[1];
        Scene scene = new Scene((Parent)this.root);
        this.stage.setScene(scene);
        this.superLauncher.setupLogFile();
        this.superLauncher.checkSSLIgnoreflag();
        this.uiProvider.init(this.stage);
        this.root.getChildren().add((Object)this.uiProvider.createLoader());
        this.stage.show();
        new Thread(() -> {
            block4: {
                Thread.currentThread().setName("FXLauncher-Thread");
                try {
                    this.superLauncher.updateManifest();
                    this.createUpdateWrapper();
                    filesUpdated[0] = this.superLauncher.syncFiles();
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, String.format(Constants.getString("Error.Start.Phase"), this.superLauncher.getPhase()), ex);
                    if (!this.superLauncher.checkIgnoreUpdateErrorSetting()) break block4;
                    this.superLauncher.reportError(String.format(Constants.getString("Error.Start.Phase"), this.superLauncher.getPhase()), ex);
                    System.exit(1);
                }
            }
            try {
                this.superLauncher.createApplicationEnvironment();
                this.launchAppFromManifest(filesUpdated[0]);
            }
            catch (Exception ex) {
                this.superLauncher.reportError(String.format(Constants.getString("Error.Start.Phase"), this.superLauncher.getPhase()), ex);
            }
        }).start();
    }

    private void launchAppFromManifest(boolean showWhatsnew) throws Exception {
        this.superLauncher.setPhase(Constants.getString("Application.Phase.Prepare"));
        try {
            this.initApplication();
        }
        catch (Throwable ex) {
            this.superLauncher.reportError(Constants.getString("Error.Application.Init"), ex);
        }
        this.superLauncher.setPhase(Constants.getString("Application.Phase.Start"));
        log.info(() -> Constants.getString("Whatsnew.Log") + showWhatsnew);
        this.runAndWait(() -> {
            try {
                if (showWhatsnew && this.superLauncher.getManifest().whatsNewPage != null) {
                    this.showWhatsNewDialog(this.superLauncher.getManifest().whatsNewPage);
                }
                if (this.superLauncher.getManifest().lingeringUpdateScreen.booleanValue()) {
                    this.primaryStage.showingProperty().addListener(observable -> {
                        if (this.stage.isShowing()) {
                            this.stage.close();
                        }
                    });
                } else {
                    this.stage.close();
                }
                this.startApplication();
            }
            catch (Throwable ex) {
                this.superLauncher.reportError(Constants.getString("Error.Application.Start"), ex);
            }
        });
    }

    private void showWhatsNewDialog(String whatsNewURL) {
        WebView view = new WebView();
        view.getEngine().load(whatsNewURL);
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(Constants.getString("Whatsnew.Title"));
        alert.setHeaderText(Constants.getString("Whatsnew.Header"));
        alert.getDialogPane().setContent((Node)view);
        alert.showAndWait();
    }

    public static void main(String[] args) {
        Launcher.launch((String[])args);
    }

    private void createUpdateWrapper() {
        this.superLauncher.setPhase(Constants.getString("Application.Phase.Wrapper"));
        Platform.runLater(() -> {
            Parent updater = this.uiProvider.createUpdater(this.superLauncher.getManifest());
            this.root.getChildren().clear();
            this.root.getChildren().add((Object)updater);
        });
    }

    public void stop() throws Exception {
        if (this.app != null) {
            this.app.stop();
        }
    }

    private void initApplication() throws Exception {
        if (this.app != null) {
            this.app.init();
        }
    }

    private void startApplication() throws Exception {
        if (this.app != null) {
            Application.Parameters appparams = this.app.getParameters();
            if (appparams != null) {
                LauncherParams params = new LauncherParams(this.getParameters(), this.superLauncher.getManifest());
                appparams.getNamed().putAll(params.getNamed());
                appparams.getRaw().addAll(params.getRaw());
                appparams.getUnnamed().addAll(params.getUnnamed());
            }
            this.superLauncher.setPhase(Constants.getString("Application.Phase.Init"));
            this.app.start(this.primaryStage);
        } else {
            String firstFile = this.superLauncher.getManifest().files.get((int)0).file;
            log.info(() -> String.format(Constants.getString("Application.log.Noappclass"), firstFile));
            Path cacheDir = this.superLauncher.getManifest().resolveCacheDir(this.getParameters().getNamed());
            String command = String.format("java -jar %s/%s", cacheDir.toAbsolutePath(), firstFile);
            log.info(() -> String.format(Constants.getString("Application.log.Execute"), command));
            Runtime.getRuntime().exec(command);
        }
    }

    void runAndWait(Runnable action) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        if (Platform.isFxApplicationThread()) {
            action.run();
            return;
        }
        CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                action.run();
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

