/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean;

import java.lang.reflect.Method;
import java.util.Objects;
import org.coliper.ibean.InvalidIBeanTypeException;
import org.coliper.ibean.beanstyle.ClassicBeanStyle;
import org.coliper.ibean.beanstyle.ClassicBeanStyleWithOptionalSupport;
import org.coliper.ibean.beanstyle.ModernBeanStyle;

public abstract class BeanStyle {
    public static final BeanStyle CLASSIC = ClassicBeanStyle.INSTANCE;
    public static final BeanStyle MODERN = ModernBeanStyle.INSTANCE;
    public static final BeanStyle CLASSIC_WITH_OPTIONAL = ClassicBeanStyleWithOptionalSupport.INSTANCE;

    protected static boolean isOneParameterInMethod(Method method) {
        Objects.requireNonNull(method, "method");
        return method.getParameterTypes().length == 1;
    }

    protected static boolean isNoParameterInMethod(Method method) {
        Objects.requireNonNull(method, "method");
        return method.getParameterTypes().length == 0;
    }

    protected static void assertForBeanType(Class<?> beanType, boolean condition, String message) throws InvalidIBeanTypeException {
        if (!condition) {
            throw new InvalidIBeanTypeException(beanType, message);
        }
    }

    public abstract boolean isGetterMethod(Method var1);

    public abstract boolean isSetterMethod(Method var1);

    public abstract String convertGetterNameToFieldName(String var1) throws IllegalArgumentException;

    public abstract String convertSetterNameToFieldName(String var1) throws IllegalArgumentException;

    public abstract Class<?> determineFieldTypeFromGetterAndSetter(Class<?> var1, Method var2, Method var3) throws InvalidIBeanTypeException;

    public Object createReturnValueForSetterCall(Object instance, Method setterMethod, Object newValue) {
        throw new IllegalStateException("createReturnValueForSetterCall() must not be calledfor bean style " + this.getClass().getName());
    }

    public Object convertReturnValueOfGetterCall(Class<?> expectedReturnType, Object returnValueWithWrongType) {
        throw new IllegalStateException("unexpected call of convertReturnValueOfGetterCall()for bean style " + this.getClass().getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

