/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.coliper.ibean.util.ReflectionUtil;

public class IBeanFieldMetaInfo {
    private final String fieldName;
    private final Class<?> fieldType;
    private final Method getterMethod;
    private final Method setterMethod;
    private final int ordinal;

    public IBeanFieldMetaInfo(String fieldName, Class<?> fieldType, Method getterMethod, Method setterMethod, int ordinal) {
        Objects.requireNonNull(fieldName, "fieldName");
        Objects.requireNonNull(fieldType, "fieldType");
        Objects.requireNonNull(getterMethod, "getterMethod");
        Objects.requireNonNull(setterMethod, "setterMethod");
        Preconditions.checkArgument((boolean)ReflectionUtil.areClassesRelated(getterMethod.getDeclaringClass(), setterMethod.getDeclaringClass()), (Object)"getterMethod and setterMethod must belong to the same class or class hierarchy");
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"ordinal must be a positive integer");
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
        this.ordinal = ordinal;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Method getterMethod() {
        return this.getterMethod;
    }

    public Method setterMethod() {
        return this.setterMethod;
    }

    public Class<?> fieldType() {
        return this.fieldType;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return "IBeanFieldMetaInfo [fieldName=" + this.fieldName + ", ordinal=" + this.ordinal + ", fieldType=" + this.fieldType + ", getterMethod=" + this.getterMethod + ", setterMethod=" + this.setterMethod + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ordinal;
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.fieldType == null ? 0 : this.fieldType.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[]{"getterMethod", "setterMethod"});
    }
}

