/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.coliper.ibean.BeanStyle;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.IBeanTypeMetaInfo;
import org.coliper.ibean.InvalidIBeanTypeException;
import org.coliper.ibean.util.ReflectionUtil;

public class IBeanMetaInfoParser {
    public <T> IBeanTypeMetaInfo<T> parse(Class<T> beanType, BeanStyle beanStyle, List<Class<?>> ignorableSuperInterfaces) throws InvalidIBeanTypeException {
        Objects.requireNonNull(beanType, "beanType");
        Objects.requireNonNull(beanStyle, "beanStyle");
        Objects.requireNonNull(ignorableSuperInterfaces, "ignorableSuperInterfaces");
        this.assertOrThrowException(beanType.isInterface(), beanType, "type is not an interface", new Object[0]);
        List<Method> getterSetterMethods = this.lookupPotentialGettersAndSetters(beanType, ignorableSuperInterfaces);
        List<IBeanFieldMetaInfo> fieldMetaList = this.createFieldMetaInfo(beanType, beanStyle, getterSetterMethods);
        return new IBeanTypeMetaInfo<T>(beanType, beanStyle, fieldMetaList);
    }

    private List<Method> lookupPotentialGettersAndSetters(Class<?> beanType, List<Class<?>> ignorableSuperInterfaces) {
        Method[] allMethods = beanType.getMethods();
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (method.getDeclaringClass() == Object.class || method.isDefault() || Modifier.isStatic(method.getModifiers()) || this.isIgnorableMethod(method, ignorableSuperInterfaces)) continue;
            filteredMethods.add(method);
        }
        return filteredMethods;
    }

    private boolean isIgnorableMethod(Method method, List<Class<?>> ignorableSuperInterfaces) {
        for (Class<?> ignorableType : ignorableSuperInterfaces) {
            if (!ReflectionUtil.doesMethodBelongToType(method, ignorableType)) continue;
            return true;
        }
        return false;
    }

    private List<IBeanFieldMetaInfo> createFieldMetaInfo(Class<?> beanType, BeanStyle beanStyle, List<Method> getterSetterMethods) {
        TreeMap<String, TempFieldMeta> metaMap = new TreeMap<String, TempFieldMeta>();
        for (Method method : getterSetterMethods) {
            this.addMethodToMetaMap(beanType, beanStyle, metaMap, method);
        }
        TempFieldMeta[] tmpMeta = metaMap.values().toArray(new TempFieldMeta[metaMap.size()]);
        for (int i = 0; i < tmpMeta.length; ++i) {
            tmpMeta[i].ordinal = i;
            this.validateMeta(beanType, tmpMeta[i]);
        }
        return Arrays.stream(tmpMeta).map(TempFieldMeta.CONVERTER).collect(Collectors.toList());
    }

    private void addMethodToMetaMap(Class<?> beanType, BeanStyle beanStyle, Map<String, TempFieldMeta> metaMap, Method method) {
        boolean isSetterOrGetter = false;
        if (beanStyle.isGetterMethod(method)) {
            this.addGetterToMetaMap(beanType, beanStyle, metaMap, method);
            isSetterOrGetter = true;
        }
        if (beanStyle.isSetterMethod(method)) {
            this.addSetterToMetaMap(beanType, beanStyle, metaMap, method);
            isSetterOrGetter = true;
        }
        this.assertOrThrowException(isSetterOrGetter, beanType, "method %s is not setter or getter", method);
    }

    private void addSetterToMetaMap(Class<?> beanType, BeanStyle beanStyle, Map<String, TempFieldMeta> metaMap, Method setter) {
        String fieldName = beanStyle.convertSetterNameToFieldName(setter.getName());
        TempFieldMeta meta = metaMap.computeIfAbsent(fieldName, k -> new TempFieldMeta((String)k));
        this.assertOrThrowException(meta.setter == null, beanType, "clashing setters %s and %s", setter, meta.setter);
        meta.setter = setter;
        this.setFieldTypeIfNullAndGetterSetterGiven(beanType, beanStyle, meta);
    }

    private void addGetterToMetaMap(Class<?> beanType, BeanStyle beanStyle, Map<String, TempFieldMeta> metaMap, Method method) {
        String fieldName = beanStyle.convertGetterNameToFieldName(method.getName());
        metaMap.computeIfAbsent(fieldName, k -> new TempFieldMeta((String)k));
        TempFieldMeta meta = metaMap.get(fieldName);
        this.assertOrThrowException(meta.getter == null, beanType, "clashing getters %s and %s", method, meta.getter);
        meta.getter = method;
        this.setFieldTypeIfNullAndGetterSetterGiven(beanType, beanStyle, meta);
    }

    private void setFieldTypeIfNullAndGetterSetterGiven(Class<?> beanType, BeanStyle beanStyle, TempFieldMeta meta) {
        if (meta.type != null) {
            return;
        }
        if (meta.getter != null && meta.setter != null) {
            meta.type = beanStyle.determineFieldTypeFromGetterAndSetter(beanType, meta.getter, meta.setter);
        }
    }

    private void validateMeta(Class<?> beanType, TempFieldMeta meta) {
        Preconditions.checkState((meta.name != null ? 1 : 0) != 0, (Object)"missing fieldName in internal structure");
        Preconditions.checkState((meta.getter != null || meta.setter != null ? 1 : 0) != 0, (Object)"missing methods in internal structure");
        this.assertOrThrowException(meta.getter != null, beanType, "missing getter for setter %s", meta.setter);
        this.assertOrThrowException(meta.setter != null, beanType, "missing setter for getter %s", meta.getter);
        Preconditions.checkState((meta.type != null ? 1 : 0) != 0, (Object)"missing field type in internal structure");
    }

    private void assertOrThrowException(boolean condition, Class<?> beanType, String message, Object ... args) {
        if (!condition) {
            throw new InvalidIBeanTypeException(beanType, String.format(message, args));
        }
    }

    private static class TempFieldMeta {
        static final Function<TempFieldMeta, IBeanFieldMetaInfo> CONVERTER = t -> new IBeanFieldMetaInfo(t.name, t.type, t.getter, t.setter, t.ordinal);
        String name;
        int ordinal;
        Class<?> type;
        Method getter;
        Method setter;

        TempFieldMeta(String name) {
            this.name = name;
        }
    }
}

