/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.coliper.ibean.BeanStyle;
import org.coliper.ibean.IBeanFieldMetaInfo;

public class IBeanTypeMetaInfo<T> {
    private final Class<T> beanType;
    private final BeanStyle beanStyle;
    private final List<IBeanFieldMetaInfo> fieldMetaInfos;

    public IBeanTypeMetaInfo(Class<T> beanType, BeanStyle beanStyle, List<IBeanFieldMetaInfo> fieldMetaInfos) {
        Objects.requireNonNull(beanType, "beanType");
        Objects.requireNonNull(beanStyle, "beanStyle");
        Objects.requireNonNull(fieldMetaInfos);
        this.beanType = beanType;
        this.beanStyle = beanStyle;
        this.fieldMetaInfos = ImmutableList.copyOf(fieldMetaInfos);
    }

    public Class<T> beanType() {
        return this.beanType;
    }

    public BeanStyle beanStyle() {
        return this.beanStyle;
    }

    public List<IBeanFieldMetaInfo> fieldMetaInfos() {
        return this.fieldMetaInfos;
    }

    public int noOfFields() {
        return this.fieldMetaInfos.size();
    }

    public Optional<IBeanFieldMetaInfo> findFieldMetaWithMethod(Method method) {
        Objects.requireNonNull(method, "method");
        for (IBeanFieldMetaInfo fieldMeta : this.fieldMetaInfos) {
            if (!fieldMeta.setterMethod().equals(method) && !fieldMeta.getterMethod().equals(method)) continue;
            return Optional.of(fieldMeta);
        }
        return Optional.empty();
    }

    public Optional<IBeanFieldMetaInfo> findFieldMetaWithFieldName(String fieldName) {
        Objects.requireNonNull(fieldName, "fieldName");
        for (IBeanFieldMetaInfo fieldMeta : this.fieldMetaInfos) {
            if (!fieldMeta.fieldName().equals(fieldName)) continue;
            return Optional.of(fieldMeta);
        }
        return Optional.empty();
    }

    public String toString() {
        return "IBeanTypeMetaInfo [beanType=" + this.beanType + ", beanStyle=" + this.beanStyle + ", fieldMetaInfos=" + this.fieldMetaInfos + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanType == null ? 0 : this.beanType.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IBeanTypeMetaInfo other = (IBeanTypeMetaInfo)obj;
        if (!this.beanType.equals(other.beanType)) {
            return false;
        }
        return this.beanStyle.equals(other.beanStyle);
    }
}

