/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.beanstyle;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Objects;
import org.coliper.ibean.BeanStyle;
import org.coliper.ibean.InvalidIBeanTypeException;

public class ClassicBeanStyle
extends BeanStyle {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_BOOL_PREFIX = "is";
    public static final ClassicBeanStyle INSTANCE = new ClassicBeanStyle();

    protected ClassicBeanStyle() {
    }

    @Override
    public boolean isGetterMethod(Method method) {
        Objects.requireNonNull(method, "method");
        if (this.hasGetterMethodSignature(method)) {
            return this.hasMethodNameRealPrefix(method, GETTER_PREFIX) || this.isBoolGetterWithIsPrefix(method);
        }
        return false;
    }

    private boolean isBoolGetterWithIsPrefix(Method method) {
        return method.getReturnType() == Boolean.TYPE && this.hasMethodNameRealPrefix(method, GETTER_BOOL_PREFIX);
    }

    @Override
    public boolean isSetterMethod(Method method) {
        Objects.requireNonNull(method, "method");
        return this.hasSetterMethodSignature(method) && this.hasMethodNameRealPrefix(method, SETTER_PREFIX);
    }

    private boolean hasMethodNameRealPrefix(Method method, String prefix) {
        return method.getName().startsWith(prefix) && prefix.length() < method.getName().length();
    }

    protected boolean hasGetterMethodSignature(Method method) {
        return ClassicBeanStyle.isNoParameterInMethod(method) && method.getReturnType() != Void.TYPE;
    }

    protected boolean hasSetterMethodSignature(Method method) {
        return ClassicBeanStyle.isOneParameterInMethod(method) && method.getReturnType() == Void.TYPE;
    }

    @Override
    public String convertGetterNameToFieldName(String getterName) {
        Objects.requireNonNull(getterName, "getterName");
        if (getterName.startsWith(GETTER_PREFIX)) {
            return this.cutOffPrefixAndDecapitalize(getterName, GETTER_PREFIX);
        }
        if (getterName.startsWith(GETTER_BOOL_PREFIX)) {
            return this.cutOffPrefixAndDecapitalize(getterName, GETTER_BOOL_PREFIX);
        }
        throw new IllegalArgumentException("invalid setter method name '" + getterName + "'");
    }

    @Override
    public String convertSetterNameToFieldName(String setterName) {
        Objects.requireNonNull(setterName, "setterName");
        Preconditions.checkArgument((boolean)setterName.startsWith(SETTER_PREFIX), (String)"invalid setter method name '%s'", (Object)setterName);
        return this.cutOffPrefixAndDecapitalize(setterName, SETTER_PREFIX);
    }

    @Override
    public Class<?> determineFieldTypeFromGetterAndSetter(Class<?> beanType, Method getterMethod, Method setterMethod) throws InvalidIBeanTypeException {
        Objects.requireNonNull(getterMethod, "getterMethod");
        Objects.requireNonNull(setterMethod, "setterMethod");
        Class<?>[] argTypes = setterMethod.getParameterTypes();
        ClassicBeanStyle.assertForBeanType(beanType, argTypes.length == 1, "unexpected no of arguments in setter " + setterMethod);
        ClassicBeanStyle.assertForBeanType(beanType, argTypes[0] == getterMethod.getReturnType(), "incompatible types of getter " + getterMethod + "with setter " + setterMethod);
        return argTypes[0];
    }

    private String cutOffPrefixAndDecapitalize(String methodName, String prefix) {
        StringBuilder fieldName = new StringBuilder(methodName);
        fieldName.delete(0, prefix.length());
        fieldName.setCharAt(0, Character.toLowerCase(fieldName.charAt(0)));
        return fieldName.toString();
    }
}

