/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.beanstyle;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.coliper.ibean.InvalidIBeanTypeException;
import org.coliper.ibean.beanstyle.ClassicBeanStyle;

public class ClassicBeanStyleWithOptionalSupport
extends ClassicBeanStyle {
    public static final ClassicBeanStyleWithOptionalSupport INSTANCE = new ClassicBeanStyleWithOptionalSupport();

    protected ClassicBeanStyleWithOptionalSupport() {
    }

    @Override
    public Class<?> determineFieldTypeFromGetterAndSetter(Class<?> beanType, Method getterMethod, Method setterMethod) throws InvalidIBeanTypeException {
        Objects.requireNonNull(getterMethod, "getterMethod");
        Objects.requireNonNull(setterMethod, "setterMethod");
        Class<?>[] argTypes = setterMethod.getParameterTypes();
        ClassicBeanStyleWithOptionalSupport.assertForBeanType(beanType, argTypes.length == 1, "unexpected no of arguments in setter " + setterMethod);
        Class<?> getterRetType = getterMethod.getReturnType();
        Class<?> setterArgType = argTypes[0];
        ClassicBeanStyleWithOptionalSupport.assertForBeanType(beanType, setterArgType == getterRetType || getterRetType == Optional.class, "incompatible types of getter " + getterMethod + "with setter " + setterMethod);
        return setterArgType;
    }

    @Override
    public Object convertReturnValueOfGetterCall(Class<?> expectedReturnType, Object returnValueWithWrongType) {
        Preconditions.checkArgument((Optional.class == expectedReturnType ? 1 : 0) != 0, (String)"unexpected return type %s for getter", expectedReturnType);
        if (returnValueWithWrongType != null) {
            return Optional.of(returnValueWithWrongType);
        }
        return Optional.empty();
    }
}

