/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.beanstyle;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.coliper.ibean.BeanStyle;
import org.coliper.ibean.InvalidIBeanTypeException;
import org.coliper.ibean.util.ReflectionUtil;

public class ModernBeanStyle
extends BeanStyle {
    public static final ModernBeanStyle INSTANCE = new ModernBeanStyle();

    protected ModernBeanStyle() {
    }

    @Override
    public boolean isGetterMethod(Method method) {
        Objects.requireNonNull(method, "method");
        return ModernBeanStyle.isNoParameterInMethod(method) && (method.getReturnType() != Void.TYPE || method.getReturnType() == Optional.class);
    }

    @Override
    public boolean isSetterMethod(Method method) {
        Objects.requireNonNull(method, "method");
        return ModernBeanStyle.isOneParameterInMethod(method) && this.methodReturnsDeclaringType(method);
    }

    private boolean methodReturnsDeclaringType(Method method) {
        return ReflectionUtil.areClassesRelated(method.getDeclaringClass(), method.getReturnType());
    }

    @Override
    public String convertGetterNameToFieldName(String getterName) {
        Objects.requireNonNull(getterName, "getterName");
        return getterName;
    }

    @Override
    public String convertSetterNameToFieldName(String setterName) {
        Objects.requireNonNull(setterName, "setterName");
        return setterName;
    }

    @Override
    public Object createReturnValueForSetterCall(Object instance, Method setterMethod, Object newValue) {
        return instance;
    }

    @Override
    public Class<?> determineFieldTypeFromGetterAndSetter(Class<?> beanType, Method getterMethod, Method setterMethod) throws InvalidIBeanTypeException {
        Objects.requireNonNull(getterMethod, "getterMethod");
        Objects.requireNonNull(setterMethod, "setterMethod");
        Class<?>[] argTypes = setterMethod.getParameterTypes();
        ModernBeanStyle.assertForBeanType(beanType, argTypes.length == 1, "unexpected no of arguments in setter " + setterMethod);
        Class<?> getterRetType = getterMethod.getReturnType();
        Class<?> setterArgType = argTypes[0];
        ModernBeanStyle.assertForBeanType(beanType, setterArgType == getterRetType || getterRetType == Optional.class, "incompatible types of getter " + getterMethod + "with setter " + setterMethod);
        return setterArgType;
    }

    @Override
    public Object convertReturnValueOfGetterCall(Class<?> expectedReturnType, Object returnValueWithWrongType) {
        Preconditions.checkArgument((Optional.class == expectedReturnType ? 1 : 0) != 0, (String)"unexpected return type %s for getter", expectedReturnType);
        if (returnValueWithWrongType != null) {
            return Optional.of(returnValueWithWrongType);
        }
        return Optional.empty();
    }
}

