/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.extension;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.coliper.ibean.IBean;
import org.coliper.ibean.IBeanFactory;
import org.coliper.ibean.extension.GsonSupport;

public class GsonSerializerDeserializerForIBeans
implements JsonSerializer<GsonSupport>,
JsonDeserializer<GsonSupport> {
    private final IBeanFactory iBeanFactory;

    public GsonSerializerDeserializerForIBeans() {
        this(null);
    }

    public GsonSerializerDeserializerForIBeans(IBeanFactory iBeanFactory) {
        this.iBeanFactory = iBeanFactory;
    }

    private <T> T createBean(Class<T> beanType) {
        if (this.iBeanFactory != null) {
            return this.iBeanFactory.create(beanType);
        }
        return IBean.newOf(beanType);
    }

    public GsonSupport deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        GsonSupport bean = (GsonSupport)this.createBean((Class)typeOfT);
        bean.readFromJsonObject(json.getAsJsonObject(), context);
        return bean;
    }

    public JsonElement serialize(GsonSupport src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        src.writeToJsonObject(jsonObject, context);
        return jsonObject;
    }
}

