/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.extension;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.coliper.ibean.IBean;
import org.coliper.ibean.IBeanFactory;
import org.coliper.ibean.extension.Jackson2Support;

class Jackson2DeserializerForIBeans
extends JsonDeserializer<Jackson2Support> {
    private final IBeanFactory iBeanFactory;
    private final Class<? extends Jackson2Support> beanType;

    Jackson2DeserializerForIBeans(IBeanFactory factory, Class<? extends Jackson2Support> beanType) {
        this.iBeanFactory = factory;
        this.beanType = beanType;
    }

    private <T> T createBean(Class<T> beanType) {
        if (this.iBeanFactory != null) {
            return this.iBeanFactory.create(beanType);
        }
        return IBean.newOf(beanType);
    }

    public Jackson2Support deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Jackson2Support bean = this.createBean(this.beanType);
        bean.readFromJsonParser(p, ctxt);
        return bean;
    }
}

