/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.extension;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import org.apache.commons.lang3.ClassUtils;
import org.coliper.ibean.IBeanFactory;
import org.coliper.ibean.extension.Jackson2DeserializerForIBeans;
import org.coliper.ibean.extension.Jackson2Support;

public class Jackson2ModuleForIBeans
extends Module {
    private static final long serialVersionUID = 1L;
    private final IBeanFactory iBeanFactory;

    public Jackson2ModuleForIBeans() {
        this(null);
    }

    public Jackson2ModuleForIBeans(IBeanFactory iBeanFactory) {
        this.iBeanFactory = iBeanFactory;
    }

    public String getModuleName() {
        return ClassUtils.getShortClassName(((Object)((Object)this)).getClass());
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new IBeanDeserializers(this.iBeanFactory));
    }

    private static class IBeanDeserializers
    extends Deserializers.Base {
        private final IBeanFactory iBeanFactory;

        IBeanDeserializers(IBeanFactory iBeanFactory) {
            this.iBeanFactory = iBeanFactory;
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (Jackson2Support.class.isAssignableFrom(type.getRawClass())) {
                return new Jackson2DeserializerForIBeans(this.iBeanFactory, type.getRawClass());
            }
            return null;
        }
    }
}

