/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.IBeanTypeMetaInfo;
import org.coliper.ibean.proxy.ExtensionHandler;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.IBeanFieldAccess;

class ExtensionHandlerDispatcher {
    private static final ExtensionHandlerDispatcher EMPTY_BUNDLES_HANDLER = new ExtensionHandlerDispatcher(Collections.emptyMap());
    private final Map<Class<?>, ExtensionHandler> handlerMap;

    private ExtensionHandlerDispatcher(Map<Class<?>, ExtensionHandler> handlerMap) {
        Objects.requireNonNull(handlerMap, "handlerMap");
        this.handlerMap = handlerMap;
    }

    Object interceptGetterCall(IBeanContext<?> context, IBeanFieldMetaInfo fieldMeta, Object returnValue, Object proxyInstance) {
        Object modifiedReturnValue = returnValue;
        for (ExtensionHandler handler : this.handlerMap.values()) {
            modifiedReturnValue = handler.interceptGetterCall(context, fieldMeta, modifiedReturnValue, proxyInstance);
        }
        return modifiedReturnValue;
    }

    Object interceptSetterCall(IBeanContext<?> context, IBeanFieldMetaInfo fieldMeta, Object newValue, Object proxyInstance) {
        Object modifiedNewValue = newValue;
        for (ExtensionHandler handler : this.handlerMap.values()) {
            modifiedNewValue = handler.interceptSetterCall(context, fieldMeta, modifiedNewValue, proxyInstance);
        }
        return modifiedNewValue;
    }

    private ExtensionHandler handlerForType(Class<?> type) {
        ExtensionHandler handler = this.handlerMap.get(type);
        if (handler == null) {
            throw new IllegalStateException("unknown type " + type);
        }
        return handler;
    }

    boolean canHandleCall(Method method) {
        Objects.requireNonNull(method, "method");
        return this.handlerMap.containsKey(method.getDeclaringClass());
    }

    Object handleExtendedInterfaceCall(IBeanContext<?> context, IBeanFieldAccess bean, Object proxyInstance, Method method, Object[] params) throws Throwable {
        return this.handlerForType(method.getDeclaringClass()).handleExtendedInterfaceCall(context, bean, proxyInstance, method, params);
    }

    void initHandler(Object proxyInstance, IBeanTypeMetaInfo<?> metaInfo) {
        for (ExtensionHandler handler : this.handlerMap.values()) {
            handler.onInitStateful(proxyInstance, metaInfo);
        }
    }

    static class Builder {
        private final ImmutableMap.Builder<Class<?>, ExtensionHandler> handlerMapBuilder = new ImmutableMap.Builder();

        Builder() {
        }

        void add(Class<?> type, ExtensionHandler handler) {
            this.handlerMapBuilder.put(type, (Object)handler);
        }

        ExtensionHandlerDispatcher build() {
            ImmutableMap map = this.handlerMapBuilder.build();
            if (map.isEmpty()) {
                return EMPTY_BUNDLES_HANDLER;
            }
            return new ExtensionHandlerDispatcher((Map)map);
        }
    }
}

