/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.coliper.ibean.proxy.ExtensionHandler;
import org.coliper.ibean.util.ReflectionUtil;

public class ExtensionSupport {
    private final Class<?> supportedInterface;
    private final Class<? extends ExtensionHandler> handlerType;
    private final boolean handlerStateful;

    private static void validateHandlerType(Class<? extends ExtensionHandler> handlerType) {
        try {
            handlerType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("class " + handlerType + "is not a valid handler type as it does not contain a public default constructor");
        }
    }

    public ExtensionSupport(Class<?> supportedInterface, Class<? extends ExtensionHandler> handlerType, boolean handlerStateful) {
        Objects.requireNonNull(supportedInterface, "supportedInterface");
        Objects.requireNonNull(handlerType, "handlerType");
        Preconditions.checkArgument((boolean)supportedInterface.isInterface(), (String)"supportedInterface %s is not an interface", supportedInterface);
        ExtensionSupport.validateHandlerType(handlerType);
        this.supportedInterface = supportedInterface;
        this.handlerType = handlerType;
        this.handlerStateful = handlerStateful;
    }

    public Class<?> supportedInterface() {
        return this.supportedInterface;
    }

    public Class<? extends ExtensionHandler> handlerType() {
        return this.handlerType;
    }

    public boolean handlerStateful() {
        return this.handlerStateful;
    }

    public List<Class<?>> supportedInterfaceAndSuperInterfaces() {
        return ReflectionUtil.getSuperTypesInclRoot(this.supportedInterface);
    }
}

