/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.proxy.ExtensionHandlerDispatcher;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.IBeanFieldAccess;
import org.coliper.ibean.util.RecursionCycleDetector;
import org.coliper.ibean.util.ReflectionUtil;

class ProxyIBean<T>
implements InvocationHandler,
IBeanFieldAccess {
    private static final String METHOD_NAME_TO_STRING = "toString";
    private static final String METHOD_NAME_HASH_CODE = "hashCode";
    private static final String METHOD_NAME_EQUALS = "equals";
    private static final RecursionCycleDetector<Object> RECURSION_DETECTOR_HASHCODE = new RecursionCycleDetector<Integer>(1);
    private static final RecursionCycleDetector<Object> RECURSION_DETECTOR_EQUALS = new RecursionCycleDetector<Boolean>(Boolean.FALSE);
    private final IBeanContext<T> context;
    private final ExtensionHandlerDispatcher extendedInterfaceHandler;
    private final Object[] beanValues;

    ProxyIBean(IBeanContext<T> context, ExtensionHandlerDispatcher handler) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(handler, "handler");
        this.context = context;
        this.extendedInterfaceHandler = handler;
        this.beanValues = this.initBeanValues(context);
    }

    private Object[] initBeanValues(IBeanContext<T> context) {
        Object[] val = new Object[context.metaInfo().noOfFields()];
        for (int i = 0; i < val.length; ++i) {
            IBeanFieldMetaInfo fieldMetaInfo = context.metaInfo().fieldMetaInfos().get(i);
            Class<?> fieldType = fieldMetaInfo.fieldType();
            if (!fieldType.isPrimitive()) continue;
            val[i] = ReflectionUtil.primitiveTypeDefaultValue(fieldType);
        }
        return val;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isRootObjectTypeMethod(method)) {
            return this.handleRootObjectTypeMethod(proxy, method, args);
        }
        if (this.extendedInterfaceHandler.canHandleCall(method)) {
            return this.extendedInterfaceHandler.handleExtendedInterfaceCall(this.context, this, proxy, method, args);
        }
        if (method.isDefault()) {
            return this.handleDefaultMethod(proxy, method, args);
        }
        return this.handleGetterOrSetter(proxy, method, args);
    }

    private Object handleDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 2)).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    private boolean isRootObjectTypeMethod(Method method) {
        return method.getDeclaringClass() == Object.class;
    }

    private Object handleRootObjectTypeMethod(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "equals": {
                Preconditions.checkState((args.length == 1 ? 1 : 0) != 0);
                return this.handleEqualsMethod(proxy, method, args[0]);
            }
            case "hashCode": {
                Preconditions.checkState((args == null || args.length == 0 ? 1 : 0) != 0);
                return this.handleHashCodeMethod(proxy, method);
            }
            case "toString": {
                Preconditions.checkState((args == null || args.length == 0 ? 1 : 0) != 0);
                return this.handleToStringMethod(proxy, method);
            }
        }
        throw new IllegalStateException("unexpected method call " + method);
    }

    private Object handleToStringMethod(Object proxy, Method method) {
        StringBuffer buffer = new StringBuffer();
        ToStringBuilder builder = new ToStringBuilder(proxy, this.context.toStringStyle(), buffer);
        this.correctClassNameInToStringBuffer(proxy, buffer);
        List<IBeanFieldMetaInfo> fieldMetas = this.context.metaInfo().fieldMetaInfos();
        for (int index = 0; index < fieldMetas.size(); ++index) {
            builder.append(fieldMetas.get(index).fieldName(), this.beanValues[index]);
        }
        return builder.build();
    }

    private void correctClassNameInToStringBuffer(Object proxy, StringBuffer buffer) {
        String proxyClassName = proxy.getClass().getName();
        String interfaceName = this.context.metaInfo().beanType().getName();
        ProxyIBean.searchAndReplaceInStringBuffer(buffer, proxyClassName, interfaceName);
        String proxyClassNameShort = ClassUtils.getShortClassName((String)proxyClassName);
        String interfaceNameShort = ClassUtils.getShortClassName((String)this.context.metaInfo().beanType().getName());
        ProxyIBean.searchAndReplaceInStringBuffer(buffer, proxyClassNameShort, interfaceNameShort);
    }

    private static boolean searchAndReplaceInStringBuffer(StringBuffer buffer, String searchString, String replaceString) {
        int index = buffer.indexOf(searchString);
        if (index >= 0) {
            buffer.replace(index, index + searchString.length(), replaceString);
            return true;
        }
        return false;
    }

    private Object handleHashCodeMethod(Object proxy, Method method) {
        return RECURSION_DETECTOR_HASHCODE.executeWithCycleDetection(proxy, () -> this.handleHashCodeMethodWithCycleProtection(proxy, method));
    }

    private Object handleHashCodeMethodWithCycleProtection(Object proxy, Method method) {
        return Arrays.hashCode(this.beanValues);
    }

    private Object handleEqualsMethod(Object proxy, Method method, Object other) {
        return RECURSION_DETECTOR_EQUALS.executeWithCycleDetection(proxy, () -> this.handleEqualsMethodWithCycleProtection(proxy, method, other));
    }

    private Object handleEqualsMethodWithCycleProtection(Object proxy, Method method, Object other) {
        if (other == null) {
            return Boolean.FALSE;
        }
        if (!proxy.getClass().equals(other.getClass())) {
            return Boolean.FALSE;
        }
        List<IBeanFieldMetaInfo> fieldMetas = this.context.metaInfo().fieldMetaInfos();
        for (int index = 0; index < fieldMetas.size(); ++index) {
            Method getter = fieldMetas.get(index).getterMethod();
            Object otherValue = ReflectionUtil.invokeMethodUnchecked(other, getter);
            if (Objects.equals(this.beanValues[index], otherValue)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object handleGetterOrSetter(Object proxy, Method method, Object[] args) {
        IBeanFieldMetaInfo meta = this.context.metaInfo().findFieldMetaWithMethod(method).orElseThrow(() -> new UnsupportedOperationException("unexpected call of " + method));
        if (method.equals(meta.getterMethod())) {
            Preconditions.checkState((args == null || args.length == 0 ? 1 : 0) != 0);
            return this.handleGetter(proxy, meta);
        }
        Preconditions.checkState((boolean)method.equals(meta.setterMethod()));
        Preconditions.checkState((args != null && args.length == 1 ? 1 : 0) != 0);
        return this.handleSetter(proxy, meta, args[0]);
    }

    private Object handleGetter(Object proxy, IBeanFieldMetaInfo fieldMeta) {
        Object originalValue = this.getFieldValue(fieldMeta);
        Object modifiedValue = this.extendedInterfaceHandler.interceptGetterCall(this.context, fieldMeta, originalValue, proxy);
        if (this.isFieldTypeDifferentToGetterReturnType(fieldMeta)) {
            modifiedValue = this.context.beanStyle().convertReturnValueOfGetterCall(fieldMeta.getterMethod().getReturnType(), modifiedValue);
        }
        return modifiedValue;
    }

    private boolean isFieldTypeDifferentToGetterReturnType(IBeanFieldMetaInfo fieldMeta) {
        return fieldMeta.fieldType() != fieldMeta.getterMethod().getReturnType();
    }

    private Object handleSetter(Object proxy, IBeanFieldMetaInfo fieldMeta, Object newValue) {
        Object modifiedValueByHandler = this.extendedInterfaceHandler.interceptSetterCall(this.context, fieldMeta, newValue, proxy);
        this.setFieldValue(fieldMeta, modifiedValueByHandler);
        if (fieldMeta.setterMethod().getReturnType() != Void.TYPE) {
            return this.context.beanStyle().createReturnValueForSetterCall(proxy, fieldMeta.setterMethod(), newValue);
        }
        return null;
    }

    @Override
    public void setFieldValue(String fieldName, Object newValue) {
        Objects.requireNonNull(fieldName, "fieldName");
        IBeanFieldMetaInfo meta = this.context.metaInfo().findFieldMetaWithFieldName(fieldName).orElseThrow(() -> new IllegalArgumentException("unknown field name '" + fieldName + "'"));
        this.setFieldValue(meta, newValue);
    }

    @Override
    public Object getFieldValue(String fieldName) {
        Objects.requireNonNull(fieldName, "fieldName");
        IBeanFieldMetaInfo meta = this.context.metaInfo().findFieldMetaWithFieldName(fieldName).orElseThrow(() -> new IllegalArgumentException("unknown field name '" + fieldName + "'"));
        return this.getFieldValue(meta);
    }

    @Override
    public void setFieldValue(IBeanFieldMetaInfo fieldMeta, Object newValue) {
        Objects.requireNonNull(fieldMeta, "fieldMeta");
        if (fieldMeta.fieldType().isPrimitive()) {
            Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"primitive type cannot be set to null");
        }
        this.beanValues[fieldMeta.ordinal()] = newValue;
    }

    @Override
    public Object getFieldValue(IBeanFieldMetaInfo fieldMeta) {
        Objects.requireNonNull(fieldMeta, "fieldMeta");
        return this.beanValues[fieldMeta.ordinal()];
    }
}

