/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.coliper.ibean.BeanStyle;
import org.coliper.ibean.CachedIBeanMetaInfoParser;
import org.coliper.ibean.IBeanFactory;
import org.coliper.ibean.IBeanMetaInfoParser;
import org.coliper.ibean.IBeanTypeMetaInfo;
import org.coliper.ibean.proxy.ExtensionHandlerDispatcher;
import org.coliper.ibean.proxy.ExtensionSupport;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.ProxyIBean;
import org.coliper.ibean.proxy.ProxyIBeanFactoryExtensionKit;
import org.coliper.ibean.proxy.handler.CloneableHandler;
import org.coliper.ibean.proxy.handler.CompletableHandler;
import org.coliper.ibean.proxy.handler.FreezableHandler;
import org.coliper.ibean.proxy.handler.GsonSupportHandler;
import org.coliper.ibean.proxy.handler.Jackson2SupportHandler;
import org.coliper.ibean.proxy.handler.ModificationAwareHandler;
import org.coliper.ibean.proxy.handler.NullSafeHandler;

public class ProxyIBeanFactory
implements IBeanFactory {
    private static List<ExtensionSupport> DEFAULT_INTERFACE_SUPPORTS = ImmutableList.of((Object)ModificationAwareHandler.SUPPORT, (Object)NullSafeHandler.SUPPORT, (Object)FreezableHandler.SUPPORT, (Object)CompletableHandler.SUPPORT, (Object)CloneableHandler.SUPPORT, (Object)GsonSupportHandler.SUPPORT, (Object)Jackson2SupportHandler.SUPPORT);
    private final IBeanMetaInfoParser metaInfoParser;
    private final ToStringStyle toStringStyle;
    private final BeanStyle beanStyle;
    private final ProxyIBeanFactoryExtensionKit extendedInterfacesKit;
    private final Map<Class<?>, IBeanContext<?>> contextCache = new ConcurrentHashMap();

    private ProxyIBeanFactory(IBeanMetaInfoParser metaInfoParser, ToStringStyle toStringStyle, BeanStyle beanStyle, ProxyIBeanFactoryExtensionKit extendedInterfacesKit) {
        this.metaInfoParser = metaInfoParser;
        this.toStringStyle = toStringStyle;
        this.beanStyle = beanStyle;
        this.extendedInterfacesKit = extendedInterfacesKit;
    }

    @Override
    public <T> T create(Class<T> beanType) {
        Class[] interfaces = new Class[]{beanType};
        IBeanContext<T> context = this.getOrCreateContext(beanType);
        ExtensionHandlerDispatcher handlerDispatcher = this.extendedInterfacesKit.createHandlerFor(context.metaInfo());
        ProxyIBean<T> handler = new ProxyIBean<T>(context, handlerDispatcher);
        T proxy = beanType.cast(Proxy.newProxyInstance(beanType.getClassLoader(), interfaces, handler));
        handlerDispatcher.initHandler(proxy, context.metaInfo());
        return proxy;
    }

    public static Builder builder() {
        return new Builder();
    }

    private <T> IBeanContext<T> getOrCreateContext(Class<T> beanType) {
        return this.contextCache.computeIfAbsent(beanType, t -> this.createContext((Class)t));
    }

    private <T> IBeanContext<T> createContext(Class<T> beanType) {
        List<Class<?>> supportedExtendedInterfaces = this.extendedInterfacesKit.getSupportedExtendedInterfaces();
        IBeanTypeMetaInfo<T> meta = this.metaInfoParser.parse(beanType, this.beanStyle, supportedExtendedInterfaces);
        return new IBeanContext<T>(this, meta, this.toStringStyle, this.beanStyle);
    }

    public static class Builder {
        private Optional<IBeanMetaInfoParser> metaInfoParser = Optional.empty();
        private Optional<ToStringStyle> toStringStyle = Optional.empty();
        private Optional<BeanStyle> beanStyle = Optional.empty();
        private List<ExtensionSupport> interfaceSupport = new ArrayList<ExtensionSupport>();

        private Builder() {
        }

        public Builder withMetaInfoParser(IBeanMetaInfoParser metaInfoParser) {
            Objects.requireNonNull(metaInfoParser);
            this.metaInfoParser = Optional.of(metaInfoParser);
            return this;
        }

        public Builder withToStringStyle(ToStringStyle toStringStyle) {
            Objects.requireNonNull(toStringStyle);
            this.toStringStyle = Optional.of(toStringStyle);
            return this;
        }

        public Builder withBeanStyle(BeanStyle beanStyle) {
            Objects.requireNonNull(beanStyle);
            this.beanStyle = Optional.of(beanStyle);
            return this;
        }

        public Builder withInterfaceSupport(ExtensionSupport support) {
            Objects.requireNonNull(support, "support");
            this.interfaceSupport.add(support);
            return this;
        }

        public Builder withDefaultInterfaceSupport() {
            this.interfaceSupport.addAll(DEFAULT_INTERFACE_SUPPORTS);
            return this;
        }

        public ProxyIBeanFactory build() {
            ProxyIBeanFactoryExtensionKit extendedInterfacesKit = new ProxyIBeanFactoryExtensionKit(this.interfaceSupport);
            return new ProxyIBeanFactory(this.metaInfoParser.orElseGet(() -> new CachedIBeanMetaInfoParser()), this.toStringStyle.orElse(ToStringStyle.SHORT_PREFIX_STYLE), this.beanStyle.orElse(BeanStyle.CLASSIC), extendedInterfacesKit);
        }
    }
}

