/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.coliper.ibean.IBeanTypeMetaInfo;
import org.coliper.ibean.proxy.ExtensionHandler;
import org.coliper.ibean.proxy.ExtensionHandlerDispatcher;
import org.coliper.ibean.proxy.ExtensionSupport;

class ProxyIBeanFactoryExtensionKit {
    private final List<IBeanHandlerInterceptorBundle> bundles;
    private final List<Class<?>> supportedInterfaces;

    private static List<IBeanHandlerInterceptorBundle> createBundleList(List<ExtensionSupport> intfSupportList) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (ExtensionSupport intfSupport : intfSupportList) {
            IBeanHandlerInterceptorBundle bundle = ProxyIBeanFactoryExtensionKit.createGlobalBundle(intfSupport);
            listBuilder.add((Object)bundle);
        }
        return listBuilder.build();
    }

    private static IBeanHandlerInterceptorBundle createGlobalBundle(ExtensionSupport intfSupport) {
        ExtensionHandler handler = intfSupport.handlerStateful() ? null : ProxyIBeanFactoryExtensionKit.createHandler(intfSupport);
        IBeanHandlerInterceptorBundle bundle = new IBeanHandlerInterceptorBundle(handler, intfSupport);
        return bundle;
    }

    private static ExtensionHandler createHandler(ExtensionSupport support) {
        try {
            return support.handlerType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static List<Class<?>> createSupportedInterfacesList(List<ExtensionSupport> intfSupportList) {
        HashSet interfaceSet = new HashSet();
        for (ExtensionSupport intfSupport : intfSupportList) {
            interfaceSet.addAll(intfSupport.supportedInterfaceAndSuperInterfaces());
        }
        return ImmutableList.copyOf(interfaceSet);
    }

    ProxyIBeanFactoryExtensionKit(List<ExtensionSupport> intfSupportList) {
        Objects.requireNonNull(intfSupportList, "intfSupportList");
        this.bundles = ProxyIBeanFactoryExtensionKit.createBundleList(intfSupportList);
        this.supportedInterfaces = ProxyIBeanFactoryExtensionKit.createSupportedInterfacesList(intfSupportList);
    }

    ExtensionHandlerDispatcher createHandlerFor(IBeanTypeMetaInfo<?> metaInfo) {
        Objects.requireNonNull(metaInfo, "metaInfo");
        ExtensionHandlerDispatcher.Builder dispatcherBuilder = new ExtensionHandlerDispatcher.Builder();
        for (IBeanHandlerInterceptorBundle bundle : this.bundles) {
            this.addHandlerForSupportedTypesToDispatcherBuilder(metaInfo, dispatcherBuilder, bundle);
        }
        return dispatcherBuilder.build();
    }

    private void addHandlerForSupportedTypesToDispatcherBuilder(IBeanTypeMetaInfo<?> metaInfo, ExtensionHandlerDispatcher.Builder dispatcherBuilder, IBeanHandlerInterceptorBundle bundle) {
        ExtensionHandler handler = bundle.handler.orElse(null);
        for (Class<?> supportedType : bundle.support.supportedInterfaceAndSuperInterfaces()) {
            if (!supportedType.isAssignableFrom(metaInfo.beanType())) continue;
            if (handler == null) {
                handler = ProxyIBeanFactoryExtensionKit.createHandler(bundle.support);
            }
            dispatcherBuilder.add(supportedType, handler);
        }
    }

    List<Class<?>> getSupportedExtendedInterfaces() {
        return this.supportedInterfaces;
    }

    private static class IBeanHandlerInterceptorBundle {
        final ExtensionSupport support;
        final Optional<ExtensionHandler> handler;

        IBeanHandlerInterceptorBundle(ExtensionHandler handler, ExtensionSupport support) {
            this.support = support;
            this.handler = Optional.ofNullable(handler);
        }
    }
}

