/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy.handler;

import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.ObjectUtils;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.IBeanTypeMetaInfo;
import org.coliper.ibean.extension.CloneableBean;
import org.coliper.ibean.proxy.ExtensionSupport;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.IBeanFieldAccess;
import org.coliper.ibean.proxy.handler.StatelessExtensionHandler;

public class CloneableHandler
extends StatelessExtensionHandler {
    public static final ExtensionSupport SUPPORT = new ExtensionSupport(CloneableBean.class, CloneableHandler.class, false);
    private static final Method CLONE_METHOD;
    private static final Method DEEP_CLONE_METHOD;
    private static final UnaryOperator<Object> CLONE_OPERATOR;

    private static void copyFields(IBeanTypeMetaInfo<?> meta, Object sourceBean, Object targetBean, UnaryOperator<Object> fieldOperator) {
        List<IBeanFieldMetaInfo> f = meta.fieldMetaInfos();
        for (IBeanFieldMetaInfo fieldMeta : f) {
            CloneableHandler.copyField(fieldMeta, sourceBean, targetBean, fieldOperator);
        }
    }

    private static void copyField(IBeanFieldMetaInfo fieldMeta, Object sourceBean, Object targetBean, UnaryOperator<Object> fieldOperator) {
        try {
            CloneableHandler.copyFieldThrowing(fieldMeta, sourceBean, targetBean, fieldOperator);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getTargetException());
            throw new RuntimeException(e.getTargetException());
        }
    }

    private static void copyFieldThrowing(IBeanFieldMetaInfo fieldMeta, Object sourceBean, Object targetBean, UnaryOperator<Object> fieldOperator) throws IllegalAccessException, InvocationTargetException {
        Object val = fieldMeta.getterMethod().invoke(sourceBean, new Object[0]);
        if (val instanceof Optional && fieldMeta.fieldType() != Optional.class) {
            Optional opt = (Optional)val;
            val = opt.orElse(null);
        }
        if (val != null && fieldOperator != null) {
            val = fieldOperator.apply(val);
        }
        fieldMeta.setterMethod().invoke(targetBean, val);
    }

    @Override
    public Object handleExtendedInterfaceCall(IBeanContext<?> context, IBeanFieldAccess bean, Object proxyInstance, Method method, Object[] params) throws Throwable {
        if (CLONE_METHOD.equals(method)) {
            return this.handleCloneCall(context, proxyInstance);
        }
        if (DEEP_CLONE_METHOD.equals(method)) {
            return this.handleDeepCloneCall(context, proxyInstance);
        }
        throw new UnsupportedOperationException("unexpected call of " + method);
    }

    private Object handleCloneCall(IBeanContext<?> context, Object proxyInstance) throws Throwable {
        Object clone = context.beanFactory().create(context.metaInfo().beanType());
        UnaryOperator<Object> fieldOperator = null;
        CloneableHandler.copyFields(context.metaInfo(), proxyInstance, clone, fieldOperator);
        return clone;
    }

    private Object handleDeepCloneCall(IBeanContext<?> context, Object proxyInstance) throws Throwable {
        Object clone = context.beanFactory().create(context.metaInfo().beanType());
        CloneableHandler.copyFields(context.metaInfo(), proxyInstance, clone, CLONE_OPERATOR);
        return clone;
    }

    static {
        try {
            CLONE_METHOD = CloneableBean.class.getMethod("clone", new Class[0]);
            DEEP_CLONE_METHOD = CloneableBean.class.getMethod("deepClone", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        CLONE_OPERATOR = new UnaryOperator<Object>(){

            @Override
            public Object apply(Object obj) {
                return this.deepClone(obj);
            }

            private <T> T deepClone(T obj) {
                if (obj == null) {
                    return null;
                }
                if (obj instanceof Collection) {
                    return (T)this.cloneCollection((Collection)obj);
                }
                if (obj instanceof Cloneable) {
                    return (T)ObjectUtils.clone(obj);
                }
                if (obj instanceof CloneableBean) {
                    return ((CloneableBean)obj).deepClone();
                }
                return obj;
            }

            private <T> Object cloneCollection(Collection<T> col) {
                if (!(col instanceof Cloneable)) {
                    return col;
                }
                Collection clone = (Collection)ObjectUtils.clone(col);
                try {
                    clone.clear();
                }
                catch (UnsupportedOperationException e) {
                    return clone;
                }
                try {
                    for (T originalElement : col) {
                        clone.add(this.deepClone(originalElement));
                    }
                }
                catch (UnsupportedOperationException e) {
                    return (Collection)ObjectUtils.clone(col);
                }
                return clone;
            }
        };
    }
}

