/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy.handler;

import java.lang.reflect.Method;
import java.util.Optional;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.extension.BeanIncompleteException;
import org.coliper.ibean.extension.Completable;
import org.coliper.ibean.proxy.ExtensionSupport;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.IBeanFieldAccess;
import org.coliper.ibean.proxy.handler.StatelessExtensionHandler;

public class CompletableHandler
extends StatelessExtensionHandler {
    public static final ExtensionSupport SUPPORT = new ExtensionSupport(Completable.class, CompletableHandler.class, false);
    private static final Method IS_COMPLETE_METHOD;
    private static final Method ASSERT_COMPLETE_METHOD;

    @Override
    public Object handleExtendedInterfaceCall(IBeanContext<?> context, IBeanFieldAccess bean, Object proxyInstance, Method method, Object[] params) throws Throwable {
        if (IS_COMPLETE_METHOD.equals(method)) {
            return this.handleIsCompleteCall(context, bean);
        }
        if (ASSERT_COMPLETE_METHOD.equals(method)) {
            return this.handleAssertCompleteCall(context, bean, proxyInstance);
        }
        throw new UnsupportedOperationException("unexpected call of " + method);
    }

    private Boolean handleIsCompleteCall(IBeanContext<?> context, IBeanFieldAccess bean) throws Throwable {
        return this.isBeanComplete(context, bean);
    }

    private Object handleAssertCompleteCall(IBeanContext<?> context, IBeanFieldAccess bean, Object proxyInstance) throws Throwable {
        if (!this.isBeanComplete(context, bean)) {
            throw new BeanIncompleteException();
        }
        return proxyInstance;
    }

    private boolean isBeanComplete(IBeanContext<?> context, IBeanFieldAccess bean) {
        for (IBeanFieldMetaInfo fieldMeta : context.metaInfo().fieldMetaInfos()) {
            if (fieldMeta.fieldType().isPrimitive() || fieldMeta.getterMethod().getReturnType() == Optional.class && fieldMeta.fieldType() != Optional.class || bean.getFieldValue(fieldMeta) != null) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            IS_COMPLETE_METHOD = Completable.class.getMethod("isComplete", new Class[0]);
            ASSERT_COMPLETE_METHOD = Completable.class.getMethod("assertComplete", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

