/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy.handler;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.extension.GsonSupport;
import org.coliper.ibean.proxy.ExtensionSupport;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.IBeanFieldAccess;
import org.coliper.ibean.proxy.handler.StatelessExtensionHandler;
import org.coliper.ibean.util.ReflectionUtil;

public class GsonSupportHandler
extends StatelessExtensionHandler {
    public static final ExtensionSupport SUPPORT = new ExtensionSupport(GsonSupport.class, GsonSupportHandler.class, false);
    private static final Method JSON_READ_METHOD = ReflectionUtil.lookupInterfaceMethod(GsonSupport.class, s -> s.readFromJsonObject(null, null));
    private static final Method JSON_WRITE_METHOD = ReflectionUtil.lookupInterfaceMethod(GsonSupport.class, s -> s.writeToJsonObject(null, null));

    @Override
    public Object handleExtendedInterfaceCall(IBeanContext<?> context, IBeanFieldAccess bean, Object proxyInstance, Method method, Object[] params) throws Throwable {
        if (JSON_WRITE_METHOD.equals(method)) {
            Objects.requireNonNull(params, "params");
            Preconditions.checkArgument((params.length == 2 ? 1 : 0) != 0);
            this.writeToJsonObject((JsonObject)params[0], (JsonSerializationContext)params[1], context, bean);
        } else if (JSON_READ_METHOD.equals(method)) {
            Objects.requireNonNull(params, "params");
            Preconditions.checkArgument((params.length == 2 ? 1 : 0) != 0);
            this.readFromJsonObject((JsonObject)params[0], (JsonDeserializationContext)params[1], context, bean);
        } else {
            throw new IllegalStateException("unexpected method call " + method);
        }
        return null;
    }

    private void readFromJsonObject(JsonObject jsonObject, JsonDeserializationContext jsonContext, IBeanContext<?> context, IBeanFieldAccess bean) throws IOException {
        Set elements = jsonObject.entrySet();
        for (Map.Entry element : elements) {
            String fieldName = (String)element.getKey();
            IBeanFieldMetaInfo meta = context.metaInfo().findFieldMetaWithFieldName(fieldName).orElseThrow(() -> new JsonSyntaxException("unknown property " + fieldName + " for type " + context.metaInfo().beanType()));
            Object value = this.readElement((JsonElement)element.getValue(), jsonContext, meta.fieldType());
            bean.setFieldValue(meta, value);
        }
    }

    private Object readElement(JsonElement value, JsonDeserializationContext jsonContext, Class<?> fieldType) {
        if (value.isJsonNull()) {
            return null;
        }
        if (ClassUtils.isPrimitiveOrWrapper(fieldType)) {
            return this.readPrimitiveElement(value, fieldType);
        }
        if (String.class == fieldType) {
            return value.getAsString();
        }
        return jsonContext.deserialize(value, fieldType);
    }

    private Object readPrimitiveElement(JsonElement value, Class<?> fieldType) {
        Class prim = Primitives.unwrap(fieldType);
        if (Boolean.TYPE == prim) {
            return value.getAsBoolean();
        }
        if (Byte.TYPE == prim) {
            return value.getAsByte();
        }
        if (Character.TYPE == prim) {
            return Character.valueOf(value.getAsCharacter());
        }
        if (Integer.TYPE == prim) {
            return value.getAsInt();
        }
        if (Short.TYPE == prim) {
            return value.getAsShort();
        }
        if (Long.TYPE == prim) {
            return value.getAsLong();
        }
        if (Double.TYPE == prim) {
            return value.getAsDouble();
        }
        if (Float.TYPE == prim) {
            return Float.valueOf(value.getAsFloat());
        }
        throw new RuntimeException("unexpected type " + fieldType);
    }

    private void writeToJsonObject(JsonObject jsonObject, JsonSerializationContext jsonContext, IBeanContext<?> context, IBeanFieldAccess bean) {
        for (IBeanFieldMetaInfo meta : context.metaInfo().fieldMetaInfos()) {
            String fieldName = meta.fieldName();
            Object value = bean.getFieldValue(meta);
            if (value == null) {
                jsonObject.add(fieldName, null);
                continue;
            }
            if (ClassUtils.isPrimitiveOrWrapper(value.getClass())) {
                this.writePrimitiveElement(jsonObject, fieldName, value);
                continue;
            }
            if (value instanceof String) {
                jsonObject.addProperty(fieldName, (String)value);
                continue;
            }
            jsonObject.add(fieldName, jsonContext.serialize(value));
        }
    }

    private void writePrimitiveElement(JsonObject jsonObject, String fieldName, Object value) {
        if (value instanceof Number) {
            jsonObject.addProperty(fieldName, (Number)value);
        } else if (value instanceof Boolean) {
            jsonObject.addProperty(fieldName, (Boolean)value);
        } else if (value instanceof Character) {
            jsonObject.addProperty(fieldName, (Character)value);
        } else {
            throw new RuntimeException("unexpected value " + value + " of type " + value.getClass());
        }
    }
}

