/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy.handler;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.extension.Jackson2Support;
import org.coliper.ibean.proxy.ExtensionSupport;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.IBeanFieldAccess;
import org.coliper.ibean.proxy.handler.StatelessExtensionHandler;
import org.coliper.ibean.util.ReflectionUtil;

public class Jackson2SupportHandler
extends StatelessExtensionHandler {
    public static final ExtensionSupport SUPPORT = new ExtensionSupport(Jackson2Support.class, Jackson2SupportHandler.class, false);
    private static final Method READ_FROM_JSON_PARSER_METHOD = ReflectionUtil.lookupInterfaceMethod(Jackson2Support.class, s -> s.readFromJsonParser(null, null));
    private static final Method SERIALIZE_METHOD = ReflectionUtil.lookupInterfaceMethod(Jackson2Support.class, s -> {
        try {
            s.serialize(null, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    });
    private static final Method SERIALIZE_WITH_TYPE_METHOD = ReflectionUtil.lookupInterfaceMethod(Jackson2Support.class, s -> {
        try {
            s.serializeWithType(null, null, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    });

    @Override
    public Object handleExtendedInterfaceCall(IBeanContext<?> context, IBeanFieldAccess bean, Object proxyInstance, Method method, Object[] params) throws Throwable {
        if (READ_FROM_JSON_PARSER_METHOD.equals(method)) {
            Objects.requireNonNull(params, "params");
            Preconditions.checkArgument((params.length == 2 ? 1 : 0) != 0);
            this.readFromJsonParser((JsonParser)params[0], (DeserializationContext)params[1], context, bean);
        } else if (SERIALIZE_METHOD.equals(method)) {
            Objects.requireNonNull(params, "params");
            Preconditions.checkArgument((params.length == 2 ? 1 : 0) != 0);
            this.serialize((JsonGenerator)params[0], (SerializerProvider)params[1], context, bean);
        } else if (SERIALIZE_WITH_TYPE_METHOD.equals(method)) {
            Objects.requireNonNull(params, "params");
            Preconditions.checkArgument((params.length == 3 ? 1 : 0) != 0);
            this.serializeWithType((JsonGenerator)params[0], (SerializerProvider)params[1], (TypeSerializer)params[2], proxyInstance, context, bean);
        } else {
            throw new IllegalStateException("unexpected method call " + method);
        }
        return null;
    }

    private void readFromJsonParser(JsonParser parser, DeserializationContext ctxt, IBeanContext<?> context, IBeanFieldAccess bean) throws IOException {
        JsonToken jsonToken = parser.nextToken();
        while (!JsonToken.END_OBJECT.equals((Object)jsonToken)) {
            if (JsonToken.FIELD_NAME.equals((Object)jsonToken)) {
                this.readField(parser, ctxt, context, bean);
            }
            jsonToken = parser.nextToken();
        }
    }

    private void readField(JsonParser parser, DeserializationContext ctxt, IBeanContext<?> context, IBeanFieldAccess bean) throws IOException, JsonParseException {
        String fieldName = parser.getCurrentName();
        parser.nextToken();
        IBeanFieldMetaInfo meta = context.metaInfo().findFieldMetaWithFieldName(fieldName).orElseThrow(() -> new JsonParseException("unknown property " + fieldName + " for type " + context.metaInfo().beanType(), parser.getCurrentLocation()));
        Object value = this.readFieldValue(parser, ctxt, meta.fieldType());
        bean.setFieldValue(meta, value);
    }

    private Object readFieldValue(JsonParser parser, DeserializationContext ctxt, Class<?> fieldType) throws IOException {
        if (JsonToken.VALUE_NULL.equals((Object)parser.getCurrentToken())) {
            return null;
        }
        if (ClassUtils.isPrimitiveOrWrapper(fieldType)) {
            return this.readPrimitiveElement(parser, fieldType);
        }
        if (String.class == fieldType) {
            return parser.getValueAsString();
        }
        return ctxt.readValue(parser, fieldType);
    }

    private Object readPrimitiveElement(JsonParser parser, Class<?> fieldType) throws IOException {
        Class prim = Primitives.unwrap(fieldType);
        if (Boolean.TYPE == prim) {
            return parser.getBooleanValue();
        }
        if (Byte.TYPE == prim) {
            return parser.getByteValue();
        }
        if (Character.TYPE == prim) {
            return Character.valueOf(parser.getValueAsString().charAt(0));
        }
        if (Integer.TYPE == prim) {
            return parser.getIntValue();
        }
        if (Short.TYPE == prim) {
            return parser.getShortValue();
        }
        if (Long.TYPE == prim) {
            return parser.getLongValue();
        }
        if (Double.TYPE == prim) {
            return parser.getDoubleValue();
        }
        if (Float.TYPE == prim) {
            return Float.valueOf(parser.getFloatValue());
        }
        throw new RuntimeException("unexpected type " + fieldType);
    }

    private void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer, Object proxyInstance, IBeanContext<?> context, IBeanFieldAccess bean) throws IOException {
        typeSer.writeTypePrefixForObject(proxyInstance, gen, context.metaInfo().beanType());
        this.serialize(gen, serializers, context, bean);
        typeSer.writeTypeSuffixForObject(proxyInstance, gen);
    }

    private void serialize(JsonGenerator gen, SerializerProvider serializers, IBeanContext<?> context, IBeanFieldAccess bean) throws IOException {
        gen.writeStartObject();
        this.serializeFields(gen, serializers, context, bean);
        gen.writeEndObject();
    }

    private void serializeFields(JsonGenerator gen, SerializerProvider serializers, IBeanContext<?> context, IBeanFieldAccess bean) throws IOException {
        for (IBeanFieldMetaInfo meta : context.metaInfo().fieldMetaInfos()) {
            String fieldName = meta.fieldName();
            gen.writeFieldName(fieldName);
            Object value = bean.getFieldValue(meta);
            serializers.defaultSerializeValue(value, gen);
        }
    }
}

