/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.proxy.handler;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.coliper.ibean.IBeanFieldMetaInfo;
import org.coliper.ibean.IBeanTypeMetaInfo;
import org.coliper.ibean.extension.ModificationAwareExt;
import org.coliper.ibean.proxy.ExtensionSupport;
import org.coliper.ibean.proxy.IBeanContext;
import org.coliper.ibean.proxy.handler.StatefulExtensionHandler;

public class ModificationAwareHandler
extends StatefulExtensionHandler
implements ModificationAwareExt {
    public static final ExtensionSupport SUPPORT = new ExtensionSupport(ModificationAwareExt.class, ModificationAwareHandler.class, true);
    private boolean modified = false;
    private boolean[] fieldModified = null;
    private IBeanTypeMetaInfo<?> beanMetaInfo = null;

    @Override
    public void onInitStateful(Object proxyInstance, IBeanTypeMetaInfo<?> metaInfo) {
        this.beanMetaInfo = metaInfo;
        if (this.beanTypeIncludesModificationAwareExt(metaInfo)) {
            this.fieldModified = new boolean[metaInfo.noOfFields()];
        }
    }

    private boolean beanTypeIncludesModificationAwareExt(IBeanTypeMetaInfo<?> metaInfo) {
        return ModificationAwareExt.class.isAssignableFrom(metaInfo.beanType());
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void resetModified() {
        this.modified = false;
        if (this.fieldModified != null) {
            Arrays.fill(this.fieldModified, false);
        }
    }

    @Override
    public Object interceptSetterCall(IBeanContext<?> context, IBeanFieldMetaInfo fieldMeta, Object newValue, Object proxyInstance) {
        this.modified = true;
        if (this.fieldModified != null) {
            this.fieldModified[fieldMeta.ordinal()] = true;
        }
        return super.interceptSetterCall(context, fieldMeta, newValue, proxyInstance);
    }

    @Override
    public String[] getModifiedFieldNames() {
        if (!this.modified) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Preconditions.checkState((this.fieldModified != null ? 1 : 0) != 0, (Object)"unexpected method call of extended interface");
        ArrayList<String> nameList = new ArrayList<String>(this.fieldModified.length);
        for (int i = 0; i < this.fieldModified.length; ++i) {
            if (!this.fieldModified[i]) continue;
            nameList.add(this.beanMetaInfo.fieldMetaInfos().get(i).fieldName());
        }
        String[] names = nameList.toArray(new String[nameList.size()]);
        return names;
    }

    @Override
    public boolean allFieldsModified() {
        Preconditions.checkState((this.fieldModified != null ? 1 : 0) != 0, (Object)"unexpected method call of extended interface");
        return !ArrayUtils.contains((boolean[])this.fieldModified, (boolean)false);
    }
}

