/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class RecursionCycleDetector<T> {
    private final ThreadLocal<List<Object>> instanceStack = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<List<Object[]>> paramStack = ThreadLocal.withInitial(ArrayList::new);
    private final T returnValueIfCycleDetected;

    public RecursionCycleDetector(T returnValueIfCycleDetected) {
        this.returnValueIfCycleDetected = returnValueIfCycleDetected;
    }

    public T executeWithCycleDetection(Object instance, Supplier<T> functionToExecute) {
        return this.executeWithCycleDetection(instance, null, functionToExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T executeWithCycleDetection(Object instance, Object[] params, Supplier<T> functionToExecute) {
        if (this.cycleDetected(instance, params)) {
            return this.returnValueIfCycleDetected;
        }
        this.instanceStack.get().add(instance);
        if (params != null && params.length > 0) {
            this.paramStack.get().add(params);
        }
        try {
            T t = functionToExecute.get();
            return t;
        }
        finally {
            this.instanceStack.get().remove(this.instanceStack.get().size() - 1);
            if (params != null && params.length > 0) {
                this.paramStack.get().remove(this.paramStack.get().size() - 1);
            }
        }
    }

    private boolean cycleDetected(Object instance, Object[] params) {
        List<Object> instList = this.instanceStack.get();
        for (int index = 0; index < instList.size(); ++index) {
            if (instance != instList.get(index)) continue;
            if (params == null || params.length == 0) {
                return true;
            }
            if (!Objects.deepEquals(params, this.paramStack.get().get(index))) continue;
            return true;
        }
        return false;
    }
}

