/*
 * Decompiled with CFR 0.152.
 */
package org.coliper.ibean.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.ClassUtils;

public class ReflectionUtil {
    private static final Map<Class<?>, Object> DEFAULTS_MAP = new ImmutableMap.Builder().put(Byte.TYPE, (Object)0).put(Short.TYPE, (Object)0).put(Integer.TYPE, (Object)0).put(Long.TYPE, (Object)0L).put(Float.TYPE, (Object)Float.valueOf(0.0f)).put(Double.TYPE, (Object)0.0).put(Boolean.TYPE, (Object)Boolean.FALSE).put(Character.TYPE, (Object)Character.valueOf('\u0000')).build();
    private static Map<Class<?>, List<Class<?>>> SUPERTYPE_INCL_CACHE = new ConcurrentHashMap();

    public static boolean areClassesRelated(Class<?> type1, Class<?> type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1 == type2 || type1.isAssignableFrom(type2) || type2.isAssignableFrom(type1);
    }

    public static boolean doesMethodBelongToType(Method method, Class<?> type) {
        return method.getDeclaringClass().isAssignableFrom(type);
    }

    public static Object invokeMethodUnchecked(Object object, Method method) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Class<?>> getSuperTypesInclRoot(Class<?> rootType) {
        return SUPERTYPE_INCL_CACHE.computeIfAbsent(rootType, t -> ReflectionUtil.getSuperTypesInclRootUncached(t));
    }

    private static List<Class<?>> getSuperTypesInclRootUncached(Class<?> rootType) {
        Objects.requireNonNull(rootType, "rootType");
        Iterable classIterable = ClassUtils.hierarchy(rootType, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        ImmutableList.Builder list = ImmutableList.builder();
        classIterable.forEach(c -> {
            if (c != Object.class) {
                list.add(c);
            }
        });
        return list.build();
    }

    public static <T> Method lookupInterfaceMethod(Class<T> interfaceType, Consumer<T> methodSpecifier) {
        Objects.requireNonNull(interfaceType, "interfaceType");
        Objects.requireNonNull(methodSpecifier, "methodSpecifier");
        Preconditions.checkArgument((boolean)interfaceType.isInterface(), (String)"%s is not an interface type", interfaceType);
        LastMethodCallRecordingProxy handler = new LastMethodCallRecordingProxy();
        Object proxy = Reflection.newProxy(interfaceType, (InvocationHandler)handler);
        methodSpecifier.accept(proxy);
        Method method = handler.getLastMethodCalled();
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"given methodSpecifier does not call a method on interface %s", interfaceType);
        return method;
    }

    public static Object primitiveTypeDefaultValue(Class<?> primitiveType) {
        Objects.requireNonNull(primitiveType, "primitiveType");
        Object ret = DEFAULTS_MAP.get(primitiveType);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"%s is not a primitive type", primitiveType);
        return ret;
    }

    private ReflectionUtil() {
    }

    private static final class LastMethodCallRecordingProxy
    implements InvocationHandler {
        private Method lastMethodCalled = null;

        private LastMethodCallRecordingProxy() {
        }

        public Method getLastMethodCalled() {
            return this.lastMethodCalled;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.lastMethodCalled = method;
            if (method.getReturnType().isPrimitive() && method.getReturnType() != Void.TYPE) {
                return ReflectionUtil.primitiveTypeDefaultValue(method.getReturnType());
            }
            return null;
        }
    }
}

