/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.gui.graphics.renderer;

import java.util.HashMap;
import java.util.Map;
import org.collebol.gui.graphics.renderer.CameraRenderer;
import org.collebol.gui.graphics.renderer.Renderer;
import org.collebol.gui.graphics.renderer.TextRenderer;
import org.collebol.gui.graphics.renderer.TextureRenderer;
import org.collebol.gui.graphics.renderer.WorldRenderer;

public class RenderHandler {
    private Map<String, TextRenderer> textRenderers = new HashMap<String, TextRenderer>();
    private Map<String, TextureRenderer> textureRenderers = new HashMap<String, TextureRenderer>();
    private CameraRenderer cameraRenderer;
    private WorldRenderer worldRenderer;

    public <T extends Renderer> void registerNewRenderer(T renderer) {
        if (renderer instanceof TextRenderer) {
            if (this.textRenderers.containsKey(((TextRenderer)renderer).getName())) {
                throw new RuntimeException("TextRenderer with the name: " + ((TextRenderer)renderer).getName() + " already exists. Please, make sure to give it a original name!");
            }
            this.textRenderers.put(((TextRenderer)renderer).getName(), (TextRenderer)renderer);
            ((TextRenderer)renderer).setup();
        }
        if (renderer instanceof TextureRenderer) {
            if (this.textureRenderers.containsKey(((TextureRenderer)renderer).getName())) {
                throw new RuntimeException("TextureRenderer with the name: " + ((TextureRenderer)renderer).getName() + " already exists. Please, make sure to give it a original name!");
            }
            this.textureRenderers.put(((TextureRenderer)renderer).getName(), (TextureRenderer)renderer);
        }
        if (renderer instanceof CameraRenderer) {
            this.cameraRenderer = (CameraRenderer)renderer;
        }
        if (renderer instanceof WorldRenderer) {
            this.worldRenderer = (WorldRenderer)renderer;
        }
    }

    public TextRenderer getTextRenderer(String name) {
        if (this.textRenderers.isEmpty()) {
            throw new RuntimeException("You are trying to display text, you have not set a TextRenderer yet. Please, register a TextRenderer in the register() method!");
        }
        if (name == "default" && !this.textRenderers.containsKey(name)) {
            throw new RuntimeException("Please, register a Default font in the register() method with the name 'default'.");
        }
        if (this.textRenderers.get(name) != null) {
            return this.textRenderers.get(name);
        }
        throw new RuntimeException("TextRender not found: " + name);
    }

    public TextureRenderer getTextureRenderer(String name) {
        if (this.textureRenderers.isEmpty()) {
            throw new RuntimeException("You are trying to display a Texture but you have not set a TextureRenderer yet. Please, register a TextureRenderer in the register() method!");
        }
        if (this.textureRenderers.get(name) != null) {
            return this.textureRenderers.get(name);
        }
        throw new RuntimeException("TextureRenderer not found: " + name);
    }

    public CameraRenderer getCameraRenderer() {
        if (this.cameraRenderer == null) {
            throw new RuntimeException("You are trying to display something relative to your Camera using the CameraRenderer, but you have not set a CameraRenderer yet. Please, register a CameraRenderer in the register() method!");
        }
        return this.cameraRenderer;
    }

    public WorldRenderer getWorldRenderer() {
        if (this.worldRenderer == null) {
            throw new RuntimeException("You are trying to display something using a WorldRenderer, but you have not set a WorldRenderer yet. Please, register a WorldRenderer in the register() method!");
        }
        return this.worldRenderer;
    }
}

