/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.gui.graphics.renderer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.collebol.EJGEngine;
import org.collebol.gui.graphics.renderer.Renderer;
import org.collebol.math.Vector2D;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.nanovg.NanoVGGL2;

public class TextRenderer
implements Renderer {
    private long vg;
    private EJGEngine engine;
    private String name;
    private String fontPath;
    public static int ALIGN_CENTER = 2;
    public static int ALIGN_TOP_LEFT = 9;
    public static int ALIGN_TOP_RIGHT = 12;
    public static int ALIGN_BOTTOM_LEFT = 33;
    public static int ALIGN_BOTTOM_RIGHT = 36;

    private EJGEngine getEngine() {
        return this.engine;
    }

    public TextRenderer(String name, String fontPath, EJGEngine e) {
        this.engine = e;
        this.name = name;
        this.fontPath = fontPath;
    }

    public void setup() {
        this.vg = NanoVGGL2.nvgCreate((int)3);
        if (this.vg == 0L) {
            throw new RuntimeException("Could not initialize NanoVG.");
        }
        int font = NanoVG.nvgCreateFont((long)this.vg, (CharSequence)this.name, (CharSequence)this.extractResourceToTempFile(this.fontPath));
        if (font == -1) {
            throw new RuntimeException("Could not add font.");
        }
    }

    public void render(TextBuilder textBuilder) {
        NanoVG.nvgBeginFrame((long)this.vg, (float)this.getEngine().getWindow().getWidth(), (float)this.getEngine().getWindow().getHeight(), (float)20.0f);
        NVGColor color = NVGColor.create();
        NanoVG.nvgRGBA((byte)-1, (byte)-1, (byte)-1, (byte)-1, (NVGColor)color);
        NanoVG.nvgSave((long)this.vg);
        NanoVG.nvgTranslate((long)this.vg, (float)textBuilder.origin.getX(), (float)textBuilder.origin.getY());
        NanoVG.nvgRotate((long)this.vg, (float)((float)Math.toRadians(textBuilder.rotation)));
        NanoVG.nvgTranslate((long)this.vg, (float)(textBuilder.position.getX() - textBuilder.origin.getX()), (float)(textBuilder.position.getY() - textBuilder.origin.getY()));
        NanoVG.nvgFontSize((long)this.vg, (float)(textBuilder.size * textBuilder.scale));
        NanoVG.nvgFontFace((long)this.vg, (CharSequence)this.name);
        NanoVG.nvgFillColor((long)this.vg, (NVGColor)color);
        NanoVG.nvgTextAlign((long)this.vg, (int)textBuilder.align);
        NanoVG.nvgText((long)this.vg, (float)0.0f, (float)0.0f, (CharSequence)textBuilder.text);
        NanoVG.nvgRestore((long)this.vg);
        NanoVG.nvgEndFrame((long)this.vg);
    }

    private String extractResourceToTempFile(String resourcePath) {
        String string;
        block16: {
            InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
            try {
                if (inputStream == null) {
                    throw new IllegalArgumentException("Resource not found: " + resourcePath);
                }
                File tempFile = Files.createTempFile("font", ".ttf", new FileAttribute[0]).toFile();
                tempFile.deleteOnExit();
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                string = tempFile.getAbsolutePath();
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load resource: " + resourcePath, e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public void cleanup() {
        NanoVGGL2.nvgDelete((long)this.vg);
    }

    public String getName() {
        return this.name;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public static class TextBuilder {
        private String text = "";
        private Vector2D position = new Vector2D(0.0f, 0.0f);
        private float size = 10.0f;
        private float scale = 1.0f;
        private int align = ALIGN_TOP_LEFT;
        private float rotation = 0.0f;
        private Vector2D origin = new Vector2D(0.0f, 0.0f);

        public TextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TextBuilder position(Vector2D position) {
            this.position = position;
            return this;
        }

        public TextBuilder size(float size) {
            this.size = size;
            return this;
        }

        public TextBuilder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public TextBuilder align(int align) {
            this.align = align;
            return this;
        }

        public TextBuilder rotation(float rotation) {
            this.rotation = rotation;
            return this;
        }

        public TextBuilder origin(Vector2D origin) {
            this.origin = origin;
            return this;
        }
    }
}

