/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui.graphics;

import org.collebol.shared.math.Vector2D;

public class Text {
    private String text;
    private Vector2D position;
    private float size;
    private float scale;
    private int align;
    private float rotation;
    private Vector2D origin;
    public static int ALIGN_CENTER = 2;
    public static int ALIGN_TOP_LEFT = 9;
    public static int ALIGN_TOP_RIGHT = 12;
    public static int ALIGN_BOTTOM_LEFT = 33;
    public static int ALIGN_BOTTOM_RIGHT = 36;

    public Text(TextBuilder builder) {
        this.text = builder.text;
        this.position = builder.position;
        this.size = builder.size;
        this.scale = builder.scale;
        this.align = builder.align;
        this.rotation = builder.rotation;
        this.origin = builder.origin;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setPosition(Vector2D position) {
        this.position = position;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public Vector2D getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector2D origin) {
        this.origin = origin;
    }

    public static class TextBuilder {
        private String text = "-";
        private Vector2D position = new Vector2D(0.0f, 0.0f);
        private float size = 10.0f;
        private float scale = 1.0f;
        private int align = ALIGN_TOP_LEFT;
        private float rotation = 0.0f;
        private Vector2D origin = new Vector2D(0.0f, 0.0f);

        public TextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TextBuilder position(Vector2D position) {
            this.position = position;
            return this;
        }

        public TextBuilder size(float size) {
            this.size = size;
            return this;
        }

        public TextBuilder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public TextBuilder align(int align) {
            this.align = align;
            return this;
        }

        public TextBuilder rotation(float rotation) {
            this.rotation = rotation;
            return this;
        }

        public TextBuilder origin(Vector2D origin) {
            this.origin = origin;
            return this;
        }
    }
}

