/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui.graphics;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Texture {
    private int id;
    private int textureObject;
    private int width;
    private int height;

    public Texture(String filePath, int id) {
        this.id = id;
        try (InputStream inputStream = this.getClass().getResourceAsStream(filePath);){
            if (inputStream == null) {
                throw new IOException("Resource not found: " + filePath);
            }
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            int[] pixels_raw = new int[this.width * this.height * 4];
            pixels_raw = bufferedImage.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            ByteBuffer pixels = BufferUtils.createByteBuffer(this.width * this.height * 4);
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    int pixel = pixels_raw[i * this.width + j];
                    pixels.put((byte)(pixel >> 16 & 0xFF));
                    pixels.put((byte)(pixel >> 8 & 0xFF));
                    pixels.put((byte)(pixel & 0xFF));
                    pixels.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            pixels.flip();
            this.textureObject = GL11.glGenTextures();
            GL11.glBindTexture(3553, this.textureObject);
            GL11.glTexParameterf(3553, 10241, 9728.0f);
            GL11.glTexParameterf(3553, 10240, 9728.0f);
            GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, pixels);
        }
        catch (IOException e) {
            throw new RuntimeException("Something went wrong making texture with id " + this.id + ", see:" + String.valueOf(e));
        }
    }

    public void bind() {
        GL11.glBindTexture(3553, this.textureObject);
    }

    public int getId() {
        return this.id;
    }
}

