/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.audio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.collebol.shared.math.Vector2D;
import org.lwjgl.openal.AL10;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.libc.LibCStdlib;

public class Sound {
    private int id;
    private int sourcePointer;
    private String path;
    private Vector2D position;
    private float volume;
    private float pitch;
    private float refDistance;
    private float rollOffFactor;

    public Sound(SoundBuilder builder) {
        int sampleRate;
        int channels;
        ShortBuffer rawAudioBuffer;
        this.id = builder.id;
        this.path = builder.path;
        this.position = builder.position;
        this.volume = builder.volume;
        this.pitch = builder.pitch;
        this.refDistance = builder.refDistance;
        this.rollOffFactor = builder.rollOffFactor;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer channelsBuffer = stack.mallocInt(1);
            IntBuffer sampleRateBuffer = stack.callocInt(1);
            rawAudioBuffer = STBVorbis.stb_vorbis_decode_filename(this.extractResourceToTempFile(this.path), channelsBuffer, sampleRateBuffer);
            channels = channelsBuffer.get(0);
            sampleRate = sampleRateBuffer.get(0);
        }
        int format = -1;
        if (channels == 1) {
            format = 4353;
        } else if (channels == 2) {
            format = 4355;
        }
        int bufferPointer = AL10.alGenBuffers();
        AL10.alBufferData(bufferPointer, format, rawAudioBuffer, sampleRate);
        LibCStdlib.free(rawAudioBuffer);
        this.sourcePointer = AL10.alGenSources();
        AL10.alSourcei(this.sourcePointer, 4105, bufferPointer);
    }

    private String extractResourceToTempFile(String resourcePath) {
        String string;
        block16: {
            InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
            try {
                if (inputStream == null) {
                    throw new IllegalArgumentException("Resource not found: " + resourcePath);
                }
                File tempFile = Files.createTempFile("sound", ".ogg", new FileAttribute[0]).toFile();
                tempFile.deleteOnExit();
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                string = tempFile.getAbsolutePath();
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load resource: " + resourcePath, e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public int getSource() {
        return this.sourcePointer;
    }

    public int getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRefDistance() {
        return this.refDistance;
    }

    public float getRollOffFactor() {
        return this.rollOffFactor;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setPosition(Vector2D position) {
        this.position = position;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setRefDistance(float refDistance) {
        this.refDistance = refDistance;
    }

    public void setRollOffFactor(float rollOffFactor) {
        this.rollOffFactor = rollOffFactor;
    }

    public static class SoundBuilder {
        private String path = null;
        private int id;
        private Vector2D position = new Vector2D(0.0f, 0.0f);
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private float refDistance = 1.0f;
        private float rollOffFactor = 1.0f;

        public SoundBuilder(int id, String path) {
            this.path = path;
            this.id = id;
        }

        public SoundBuilder position(Vector2D position) {
            this.position = position;
            return this;
        }

        public SoundBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        public SoundBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public SoundBuilder refDistance(float refDistance) {
            this.refDistance = refDistance;
            return this;
        }

        public SoundBuilder rollOffFactor(float factor) {
            this.rollOffFactor = factor;
            return this;
        }
    }
}

