/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.event.client.field;

import java.util.List;
import java.util.Map;
import org.collebol.engine.event.Event;
import org.collebol.engine.gui.graphics.ui.Component;
import org.collebol.engine.gui.graphics.ui.component.Field;
import org.collebol.engine.input.KeyType;
import org.collebol.engine.math.ComponentCalculator;
import org.collebol.shared.math.Vector2D;

public class ClientFieldClickEvent
extends Event {
    private Vector2D position;
    private KeyType keyType;
    private boolean press;
    private Field field;
    private List<Component> actionSubComponent;

    public ClientFieldClickEvent() {
    }

    public ClientFieldClickEvent(Vector2D position, KeyType keyType, boolean press, Field field) {
        this.position = position;
        this.keyType = keyType;
        this.press = press;
        this.field = field;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public Field getField() {
        return this.field;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public boolean isPressed() {
        return this.press;
    }

    public boolean isReleased() {
        return !this.press;
    }

    public boolean isSubCommandClicked() {
        return this.actionSubComponent != null;
    }

    public List<Component> getClickedSubComponents() {
        return this.actionSubComponent;
    }

    @Override
    public void setValues(Map<Class<?>, Object> params) {
        this.position = (Vector2D)params.get(Vector2D.class);
        this.keyType = (KeyType)((Object)params.get(KeyType.class));
        this.press = (Boolean)params.get(Boolean.class);
        this.field = (Field)params.get(Component.class);
        List<Component> l = ComponentCalculator.checkIfSubComponent(this.field, this.position);
        this.actionSubComponent = l;
    }
}

