/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.gui.graphics.renderer;

import java.util.List;
import java.util.Map;
import org.collebol.engine.EJGEngine;
import org.collebol.engine.gui.graphics.Camera;
import org.collebol.engine.gui.graphics.Light;
import org.collebol.engine.gui.graphics.Text;
import org.collebol.engine.gui.graphics.renderer.Batch;
import org.collebol.engine.gui.graphics.renderer.Renderer;
import org.collebol.engine.math.FrustumCulling;
import org.collebol.shared.GameLocation;
import org.collebol.shared.math.Vector2D;
import org.collebol.shared.objects.GameObject;
import org.lwjgl.opengl.GL11;

public class CameraRenderer
extends Renderer {
    private EJGEngine engine;

    public CameraRenderer(EJGEngine e) {
        this.engine = e;
    }

    public void renderObjects(List<GameObject> gameObjects) {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        for (GameObject g : gameObjects) {
            float y;
            float x = (float)(g.getGameLocation().getX() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getX() + (double)camera.getOrigin().getX());
            Vector2D v = new Vector2D(x, y = (float)(g.getGameLocation().getY() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getY() + (double)camera.getOrigin().getY()));
            if (!FrustumCulling.isInFrustum(camera, v, this.engine)) continue;
            this.engine.getRenderers().getTextureRenderer("default").render(g.getTexture(), v, camera.getZoom(), camera.getRotation(), camera.getOrigin(), camera.isLighting());
        }
    }

    public void renderBatchObjects(Map<Integer, List<GameObject>> gameObjects) {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        for (int i : gameObjects.keySet()) {
            Batch batch = new Batch(i);
            for (GameObject obj : gameObjects.get(i)) {
                float y;
                float x = (float)(obj.getGameLocation().getX() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getX() + (double)camera.getOrigin().getX());
                Vector2D v = new Vector2D(x, y = (float)(obj.getGameLocation().getY() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getY() + (double)camera.getOrigin().getY()));
                if (!FrustumCulling.isInFrustum(camera, v, this.engine)) continue;
                batch.addItem(v, camera.getZoom(), camera.getRotation(), camera.getOrigin());
            }
            this.engine.getRenderers().getTextureRenderer("default").renderBatch(batch, camera.isLighting());
        }
    }

    public void renderObject(GameObject gameObject) {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        float x = (float)(gameObject.getGameLocation().getX() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getX() + (double)camera.getOrigin().getX());
        float y = (float)(gameObject.getGameLocation().getY() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getY() + (double)camera.getOrigin().getY());
        Vector2D v = new Vector2D(x, y);
        this.engine.getRenderers().getTextureRenderer("default").render(gameObject.getTexture(), v, camera.getZoom(), camera.getRotation(), camera.getOrigin(), camera.isLighting());
    }

    public void renderText(TextBuilder textBuilder) {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        float x = (float)(textBuilder.location.getX() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getX() + (double)camera.getOrigin().getX());
        float y = (float)(textBuilder.location.getY() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getY() + (double)camera.getOrigin().getY());
        Vector2D v = new Vector2D(x, y);
        this.engine.getRenderers().getTextRenderer(textBuilder.font).render(new Text(new Text.TextBuilder().text(textBuilder.text).position(v).size(textBuilder.size).scale(camera.getZoom()).align(textBuilder.align).rotation(camera.getRotation()).origin(camera.getOrigin())));
    }

    public void renderLight(int id, GameLocation location, float radius, float[] color) {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        float x = (float)(location.getX() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getX() + (double)camera.getOrigin().getX());
        float y = (float)(location.getY() * (double)((float)this.engine.getWindow().getTileSize() * camera.getZoom()) - (double)camera.getPosition().getY() + (double)camera.getOrigin().getY());
        Light light = new Light(new Light.LightBuilder().intensity(1.0f).color(color).radius(radius).position(new Vector2D(x, y)));
        this.engine.getRenderers().getTextureRenderer("default").applyLight(id, light, camera.getZoom(), camera.getAmbientLight());
    }

    public void showOriginPoint() {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        Vector2D origin = camera.getOrigin();
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        GL11.glPointSize(5.0f);
        GL11.glBegin(0);
        GL11.glVertex2f(origin.getX(), origin.getY());
        GL11.glEnd();
        GL11.glBegin(2);
        int numSegments = 100;
        float radius = 7.0f;
        for (int i = 0; i < numSegments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numSegments;
            float x = (float)((double)origin.getX() + (double)radius * Math.cos(angle));
            float y = (float)((double)origin.getY() + (double)radius * Math.sin(angle));
            GL11.glVertex2f(x, y);
        }
        GL11.glEnd();
    }

    public void showCoordinates() {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        GameLocation pointerLoc = camera.getGameLocation();
        GameLocation mouseLoc = this.engine.getWindow().getMouseHandler().getGameLocation();
        Vector2D mousePos = this.engine.getWindow().getMouseHandler().getPosition();
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Mouse GameLocation [ X: " + mouseLoc.getX() + " / Y: " + mouseLoc.getY() + "]").position(new Vector2D(10.0f, 5.0f)).size(13.0f).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Camera-origin GameLocation [ X: " + pointerLoc.getX() + " / Y: " + pointerLoc.getY() + "]").position(new Vector2D(10.0f, 20.0f)).size(13.0f).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Mouse Panel position [ X: " + mousePos.getX() + " / Y: " + mousePos.getY() + "]").position(new Vector2D(10.0f, 50.0f)).size(13.0f).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Camera-origin Panel position [ X: " + camera.getOrigin().getX() + " / Y: " + camera.getOrigin().getY() + "]").position(new Vector2D(10.0f, 65.0f)).size(13.0f).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Camera zoom (scale): " + (float)Math.round(camera.getZoom() * 100.0f) / 100.0f).position(new Vector2D(10.0f, 95.0f)).size(13.0f).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text("Camera rotation: " + (float)Math.round(camera.getRotation() * 100.0f) / 100.0f).position(new Vector2D(10.0f, 110.0f)).size(13.0f).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
        this.engine.getRenderers().getTextRenderer("default").render(new Text(new Text.TextBuilder().text(mouseLoc.getX() + " / " + mouseLoc.getY()).position(new Vector2D(mousePos.getX(), mousePos.getY() - 15.0f)).size(13.0f).scale(1.0f).align(Text.ALIGN_TOP_LEFT).rotation(0.0f)));
    }

    public void showGridLines() {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        float tileSize = (float)this.engine.getWindow().getTileSize() * camera.getZoom();
        float offsetX = camera.getPosition().getX();
        float offsetY = camera.getPosition().getY();
        float originX = camera.getOrigin().getX();
        float originY = camera.getOrigin().getY();
        float screenWidth = this.engine.getWindow().getWidth();
        float screenHeight = this.engine.getWindow().getHeight();
        float startX = -(offsetX % tileSize) + originX % tileSize;
        float startY = -(offsetY % tileSize) + originY % tileSize;
        if (startX > 0.0f) {
            startX -= tileSize;
        }
        if (startY > 0.0f) {
            startY -= tileSize;
        }
        GL11.glPushMatrix();
        GL11.glDisable(2896);
        GL11.glTranslatef(camera.getOrigin().getX(), camera.getOrigin().getY(), 0.0f);
        GL11.glRotatef(camera.getRotation(), 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-camera.getOrigin().getX(), -camera.getOrigin().getY(), 0.0f);
        GL11.glColor4f(1.0f, 1.0f, 0.0f, 1.0f);
        GL11.glBegin(1);
        for (float x = startX; x <= screenWidth; x += tileSize) {
            GL11.glVertex2f(x, 0.0f);
            GL11.glVertex2f(x, screenHeight);
        }
        for (float y = startY; y <= screenHeight; y += tileSize) {
            GL11.glVertex2f(0.0f, y);
            GL11.glVertex2f(screenWidth, y);
        }
        GL11.glEnd();
        GL11.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        float squareSize = Math.min(screenWidth, screenHeight);
        float halfSquare = squareSize / 2.0f;
        float squareLeft = originX - halfSquare;
        float squareRight = originX + halfSquare;
        float squareTop = originY - halfSquare;
        float squareBottom = originY + halfSquare;
        GL11.glBegin(1);
        GL11.glVertex2f(squareLeft, squareTop);
        GL11.glVertex2f(squareRight, squareBottom);
        GL11.glVertex2f(squareLeft, squareBottom);
        GL11.glVertex2f(squareRight, squareTop);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static class TextBuilder {
        private String text = "";
        private GameLocation location = new GameLocation(0.0, 0.0);
        private float size = 10.0f;
        private String font = "default";
        private int align = Text.ALIGN_TOP_LEFT;

        public TextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TextBuilder location(GameLocation location) {
            this.location = location;
            return this;
        }

        public TextBuilder size(float size) {
            this.size = size;
            return this;
        }

        public TextBuilder font(String font) {
            this.font = font;
            return this;
        }

        public TextBuilder align(int align) {
            this.align = align;
            return this;
        }
    }
}

