/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.gui.graphics.renderer.ui;

import org.collebol.engine.EJGEngine;
import org.collebol.engine.gui.graphics.renderer.Renderer;
import org.collebol.engine.gui.graphics.ui.Component;
import org.collebol.engine.gui.graphics.ui.component.Button;
import org.collebol.engine.gui.graphics.ui.component.Field;
import org.lwjgl.opengl.GL11;

public class FieldRenderer
extends Renderer {
    private final EJGEngine engine;

    public FieldRenderer(EJGEngine engine) {
        this.engine = engine;
    }

    public void renderField(int id) {
        Field field = (Field)this.engine.getComponentHandler().getComponent(Field.class, id);
        GL11.glDisable(2896);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        float x = field.getPosition().getX();
        float y = field.getPosition().getY();
        float width = field.getWidth();
        float height = field.getHeight();
        float borderSize = field.getBorderSize();
        float[] borderColor = field.getBorderColor();
        GL11.glBegin(7);
        GL11.glColor4fv(field.getBackgroundColor());
        GL11.glVertex2f(x, y);
        GL11.glVertex2f(x, y + height);
        GL11.glVertex2f(x + width, y + height);
        GL11.glVertex2f(x + width, y);
        GL11.glEnd();
        if (borderSize > 0.0f) {
            GL11.glLineWidth(borderSize);
            GL11.glColor4fv(borderColor);
            GL11.glBegin(2);
            GL11.glVertex2f(x, y);
            GL11.glVertex2f(x, y + height);
            GL11.glVertex2f(x + width, y + height);
            GL11.glVertex2f(x + width, y);
            GL11.glEnd();
        }
        if (field.subComponents().getComponents() != null) {
            for (Component c : field.subComponents().getComponents().values()) {
                if (c instanceof Field) {
                    this.engine.getRenderers().getUiRenderer().renderSubComponent(Field.class, c.getId(), field.getId());
                }
                if (!(c instanceof Button)) continue;
                this.engine.getRenderers().getUiRenderer().renderSubComponent(Button.class, c.getId(), field.getId());
            }
        }
    }

    public void renderSubField(int id, int parentId) {
        Field parent = (Field)this.engine.getComponentHandler().getComponent(Field.class, parentId);
        Field field = (Field)parent.subComponents().getComponent(Field.class, id);
        GL11.glDisable(2896);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        float x = field.getPosition().getX() + parent.getPosition().getX();
        float y = field.getPosition().getY() + parent.getPosition().getY();
        float width = field.getWidth();
        float height = field.getHeight();
        float borderSize = field.getBorderSize();
        float[] borderColor = field.getBorderColor();
        GL11.glBegin(7);
        GL11.glColor4fv(field.getBackgroundColor());
        GL11.glVertex2f(x, y);
        GL11.glVertex2f(x, y + height);
        GL11.glVertex2f(x + width, y + height);
        GL11.glVertex2f(x + width, y);
        GL11.glEnd();
        if (borderSize > 0.0f) {
            GL11.glLineWidth(borderSize);
            GL11.glColor4fv(borderColor);
            GL11.glBegin(2);
            GL11.glVertex2f(x, y);
            GL11.glVertex2f(x, y + height);
            GL11.glVertex2f(x + width, y + height);
            GL11.glVertex2f(x + width, y);
            GL11.glEnd();
        }
    }
}

