/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.input;

import java.util.ArrayList;
import java.util.List;
import org.collebol.engine.EJGEngine;
import org.collebol.engine.event.client.ClientLeftClickEvent;
import org.collebol.engine.event.client.ClientRightClickEvent;
import org.collebol.engine.event.client.button.ClientButtonClickEvent;
import org.collebol.engine.event.client.button.ClientButtonHoverEvent;
import org.collebol.engine.event.client.field.ClientFieldClickEvent;
import org.collebol.engine.event.client.field.ClientFieldHoverEvent;
import org.collebol.engine.event.client.field.ClientFieldSubHoverEvent;
import org.collebol.engine.gui.graphics.Camera;
import org.collebol.engine.gui.graphics.ui.Component;
import org.collebol.engine.gui.graphics.ui.component.Button;
import org.collebol.engine.gui.graphics.ui.component.Field;
import org.collebol.engine.input.KeyType;
import org.collebol.engine.math.ComponentCalculator;
import org.collebol.shared.GameLocation;
import org.collebol.shared.math.Vector2D;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;

public class MouseHandler {
    private boolean leftPressed;
    private boolean rightPressed;
    private Vector2D position = new Vector2D(0.0f, 0.0f);
    private EJGEngine engine;

    public MouseHandler(EJGEngine e) {
        this.engine = e;
    }

    public void registerCallbacks(long window) {
        GLFW.glfwSetMouseButtonCallback(window, new GLFWMouseButtonCallback(){

            @Override
            public void invoke(long window, int button, int action, int mods) {
                block11: {
                    Button button1;
                    Field field;
                    block12: {
                        if (button == 0) {
                            boolean bl = MouseHandler.this.leftPressed = action == 1;
                            if (action == 1) {
                                MouseHandler.this.engine.getEventHandler().callClientEvent(ClientLeftClickEvent.class).call(MouseHandler.this.engine, true, MouseHandler.this.position);
                                for (Component c : ComponentCalculator.getComponentUnderMouse(MouseHandler.this.position, MouseHandler.this.engine)) {
                                    if (c instanceof Field) {
                                        field = (Field)c;
                                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldClickEvent.class).call(MouseHandler.this.engine, new Object[]{true, MouseHandler.this.position, field, KeyType.LEFT_MOUSE});
                                    }
                                    if (!(c instanceof Button)) continue;
                                    button1 = (Button)c;
                                    MouseHandler.this.engine.getEventHandler().callClientEvent(ClientButtonClickEvent.class).call(MouseHandler.this.engine, new Object[]{true, MouseHandler.this.position, button1, KeyType.LEFT_MOUSE});
                                }
                            } else {
                                MouseHandler.this.engine.getEventHandler().callClientEvent(ClientLeftClickEvent.class).call(MouseHandler.this.engine, false, MouseHandler.this.position);
                                for (Component c : ComponentCalculator.getComponentUnderMouse(MouseHandler.this.position, MouseHandler.this.engine)) {
                                    if (c instanceof Field) {
                                        field = (Field)c;
                                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldClickEvent.class).call(MouseHandler.this.engine, new Object[]{false, MouseHandler.this.position, field, KeyType.LEFT_MOUSE});
                                    }
                                    if (!(c instanceof Button)) continue;
                                    button1 = (Button)c;
                                    MouseHandler.this.engine.getEventHandler().callClientEvent(ClientButtonClickEvent.class).call(MouseHandler.this.engine, new Object[]{false, MouseHandler.this.position, button1, KeyType.LEFT_MOUSE});
                                }
                            }
                        }
                        if (button != 1) break block11;
                        boolean bl = MouseHandler.this.rightPressed = action == 1;
                        if (action != 1) break block12;
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientRightClickEvent.class).call(MouseHandler.this.engine, true, MouseHandler.this.position);
                        for (Component c : ComponentCalculator.getComponentUnderMouse(MouseHandler.this.position, MouseHandler.this.engine)) {
                            if (c instanceof Field) {
                                field = (Field)c;
                                MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldClickEvent.class).call(MouseHandler.this.engine, new Object[]{true, MouseHandler.this.position, field, KeyType.RIGHT_MOUSE});
                            }
                            if (!(c instanceof Button)) continue;
                            button1 = (Button)c;
                            MouseHandler.this.engine.getEventHandler().callClientEvent(ClientButtonClickEvent.class).call(MouseHandler.this.engine, new Object[]{true, MouseHandler.this.position, button1, KeyType.RIGHT_MOUSE});
                        }
                        break block11;
                    }
                    if (action != 0) break block11;
                    MouseHandler.this.engine.getEventHandler().callClientEvent(ClientRightClickEvent.class).call(MouseHandler.this.engine, false, MouseHandler.this.position);
                    for (Component c : ComponentCalculator.getComponentUnderMouse(MouseHandler.this.position, MouseHandler.this.engine)) {
                        if (c instanceof Field) {
                            field = (Field)c;
                            MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldClickEvent.class).call(MouseHandler.this.engine, new Object[]{false, MouseHandler.this.position, field, KeyType.RIGHT_MOUSE});
                        }
                        if (!(c instanceof Button)) continue;
                        button1 = (Button)c;
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientButtonClickEvent.class).call(MouseHandler.this.engine, new Object[]{false, MouseHandler.this.position, button1, KeyType.RIGHT_MOUSE});
                    }
                }
            }
        });
        GLFW.glfwSetCursorPosCallback(window, new GLFWCursorPosCallback(){
            private List<Component> enteredComponentList = new ArrayList<Component>();
            private List<Component> enteredSubComponentList = new ArrayList<Component>();

            @Override
            public void invoke(long window, double xpos, double ypos) {
                List<Component> l;
                MouseHandler.this.position.setX((float)xpos);
                MouseHandler.this.position.setY((float)ypos);
                List<Component> currentHoveredComp = ComponentCalculator.getComponentUnderMouse(MouseHandler.this.position, MouseHandler.this.engine);
                ArrayList<Component> currentHoveredSubComp = new ArrayList<Component>();
                for (Component component : new ArrayList<Component>(this.enteredComponentList)) {
                    if (!currentHoveredComp.contains(component)) {
                        if (component instanceof Field) {
                            MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldHoverEvent.class).call(MouseHandler.this.engine, MouseHandler.this.position, component, false);
                            this.enteredComponentList.remove(component);
                        }
                        if (component instanceof Button) {
                            MouseHandler.this.engine.getEventHandler().callClientEvent(ClientButtonHoverEvent.class).call(MouseHandler.this.engine, MouseHandler.this.position, component, false);
                            this.enteredComponentList.remove(component);
                        }
                    }
                    if (!(component instanceof Field)) continue;
                    l = ComponentCalculator.checkIfSubComponent((Field)component, MouseHandler.this.position);
                    if (l == null) {
                        l = new ArrayList<Component>();
                    }
                    currentHoveredSubComp.addAll(l);
                    for (Component sub : new ArrayList<Component>(this.enteredSubComponentList)) {
                        if (currentHoveredSubComp.contains(sub)) continue;
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldSubHoverEvent.class).call(MouseHandler.this.engine, MouseHandler.this.position, component, false, sub.getId());
                        this.enteredSubComponentList.remove(sub);
                    }
                }
                for (Component component : currentHoveredComp) {
                    if (!this.enteredComponentList.contains(component)) {
                        if (component instanceof Field) {
                            MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldHoverEvent.class).call(MouseHandler.this.engine, MouseHandler.this.position, component, true);
                            this.enteredComponentList.add(component);
                        }
                        if (component instanceof Button) {
                            MouseHandler.this.engine.getEventHandler().callClientEvent(ClientButtonHoverEvent.class).call(MouseHandler.this.engine, MouseHandler.this.position, component, true);
                            this.enteredComponentList.add(component);
                        }
                    }
                    if (!(component instanceof Field)) continue;
                    if (((Field)component).subComponents().getComponents() == null) {
                        return;
                    }
                    l = ComponentCalculator.checkIfSubComponent((Field)component, MouseHandler.this.position);
                    if (l == null) {
                        l = new ArrayList<Component>();
                    }
                    if (l.isEmpty()) {
                        return;
                    }
                    currentHoveredSubComp.addAll(l);
                    for (Component sub : currentHoveredSubComp) {
                        if (this.enteredSubComponentList.contains(sub)) continue;
                        MouseHandler.this.engine.getEventHandler().callClientEvent(ClientFieldSubHoverEvent.class).call(MouseHandler.this.engine, MouseHandler.this.position, component, true, sub.getId());
                        this.enteredSubComponentList.add(sub);
                    }
                }
            }
        });
    }

    public boolean isLeftPressed() {
        return this.leftPressed;
    }

    public void setLeftPressed(boolean leftPressed) {
        this.leftPressed = leftPressed;
    }

    public boolean isRightPressed() {
        return this.rightPressed;
    }

    public void setRightPressed(boolean rightPressed) {
        this.rightPressed = rightPressed;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setPosition(Vector2D position) {
        this.position = position;
    }

    public GameLocation getGameLocation() {
        Camera camera = this.engine.getWindow().getCurrentPanel().getCamera();
        GameLocation location = camera.calculate().getGameLocationFromPanelPosition(this.position);
        float x = (this.position.getX() + camera.getPosition().getX() - camera.getOrigin().getX()) / ((float)this.engine.getWindow().getTileSize() * camera.getZoom());
        float y = (this.position.getY() + camera.getPosition().getY() - camera.getOrigin().getY()) / ((float)this.engine.getWindow().getTileSize() * camera.getZoom());
        Vector2D v = new Vector2D(x, y);
        return location;
    }
}

