/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.game.world;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.collebol.game.world.Chunk;
import org.collebol.game.world.World;
import org.collebol.shared.GameLocation;
import org.collebol.shared.objects.GameObject;

public class WorldFileManager {
    private World world;

    public WorldFileManager(World world) {
        this.world = world;
    }

    public void saveChunk(Chunk chunk) {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.world.getWorldFolder().getPath() + "/chunks/chunk_" + chunk.getX() + "_" + chunk.getY() + ".bin"));){
            dos.writeInt(chunk.getX());
            dos.writeInt(chunk.getY());
            dos.writeInt(chunk.getTiles().size());
            for (GameObject tile : chunk.getTiles()) {
                dos.writeInt((int)tile.getGameLocation().getX());
                dos.writeInt((int)tile.getGameLocation().getY());
                dos.writeInt(tile.getTexture());
            }
            dos.writeInt(chunk.getEntities().size());
            for (GameObject gameObject : chunk.getEntities()) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Chunk loadChunk(int chunkX, int chunkY) {
        Chunk chunk;
        File file = new File(this.world.getWorldFolder().getPath() + "/chunks/chunk_" + chunkX + "_" + chunkY + ".bin");
        if (!file.exists()) {
            return null;
        }
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        try {
            Chunk chunk2 = (Chunk)this.world.getChunkFormat().getConstructor(Integer.TYPE, Integer.TYPE).newInstance(chunkX, chunkY);
            chunk2.setX(dis.readInt());
            chunk2.setY(dis.readInt());
            int tileCount = dis.readInt();
            for (int i = 0; i < tileCount; ++i) {
                int x = dis.readInt();
                int y = dis.readInt();
                int id = dis.readInt();
                GameObject tile = new GameObject();
                tile.setGameLocation(new GameLocation(x, y));
                tile.setTexture(id);
                chunk2.addTile(tile);
            }
            int entityCount = dis.readInt();
            for (int i = 0; i < entityCount; ++i) {
            }
            chunk = chunk2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        dis.close();
        return chunk;
    }
}

