/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.math;

import org.collebol.client.EJGEngine;
import org.collebol.client.gui.graphics.Camera;
import org.collebol.shared.GameLocation;
import org.collebol.shared.math.Vector2D;

public class CameraCalculator {
    private Camera camera;
    private EJGEngine engine;

    public CameraCalculator(Camera camera, EJGEngine e) {
        this.camera = camera;
        this.engine = e;
    }

    public GameLocation getGameLocationFromPanelPosition(Vector2D position) {
        float tileSize = this.engine.getWindow().getTileSize();
        float zoom = this.camera.getZoom();
        Vector2D cameraPos = this.camera.getPosition();
        Vector2D cameraOrigin = this.camera.getOrigin();
        float localX = position.getX() - cameraOrigin.getX();
        float localY = position.getY() - cameraOrigin.getY();
        float rotation = this.camera.getRotation();
        float radians = (float)Math.toRadians(-rotation);
        float rotatedX = (float)((double)localX * Math.cos(radians) - (double)localY * Math.sin(radians));
        float rotatedY = (float)((double)localX * Math.sin(radians) + (double)localY * Math.cos(radians));
        float worldX = (rotatedX + cameraPos.getX()) / (tileSize * zoom);
        float worldY = (rotatedY + cameraPos.getY()) / (tileSize * zoom);
        return new GameLocation(worldX, worldY);
    }

    public Vector2D getPanelPositionFromGameLocation(GameLocation gameLocation) {
        float tileSize = this.engine.getWindow().getTileSize();
        float zoom = this.camera.getZoom();
        Vector2D cameraPos = this.camera.getPosition();
        Vector2D cameraOrigin = this.camera.getOrigin();
        float worldX = (float)(gameLocation.getX() * (double)tileSize * (double)zoom - (double)cameraPos.getX());
        float worldY = (float)(gameLocation.getY() * (double)tileSize * (double)zoom - (double)cameraPos.getY());
        float rotation = this.camera.getRotation();
        float radians = (float)Math.toRadians(rotation);
        float rotatedX = (float)((double)worldX * Math.cos(radians) - (double)worldY * Math.sin(radians));
        float rotatedY = (float)((double)worldX * Math.sin(radians) + (double)worldY * Math.cos(radians));
        float panelX = rotatedX + cameraOrigin.getX();
        float panelY = rotatedY + cameraOrigin.getY();
        return new Vector2D(panelX, panelY);
    }
}

