/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.physics.collision;

import org.collebol.client.physics.collision.Collider;
import org.collebol.shared.math.Vector2D;

public class BoxCollider
extends Collider {
    public BoxCollider() {
    }

    public BoxCollider(float width, float height, Vector2D origin) {
        this.setWidth(width);
        this.setHeight(height);
        this.setOrigin(origin);
    }

    public BoxCollider(BoxColliderBuilder builder) {
        this.setWidth(builder.width);
        this.setHeight(builder.height);
        this.setOrigin(builder.origin);
    }

    public boolean collidesWith(Collider other) {
        return this.getOrigin().getX() < other.getOrigin().getX() + other.getWidth() && this.getOrigin().getX() + this.getWidth() > other.getOrigin().getX() && this.getOrigin().getY() < other.getOrigin().getY() + other.getHeight() && this.getOrigin().getY() + this.getHeight() > other.getOrigin().getY();
    }

    public static class BoxColliderBuilder {
        private Vector2D origin = new Vector2D(0.0f, 0.0f);
        private float width = 0.0f;
        private float height = 0.0f;

        public BoxColliderBuilder origin(Vector2D origin) {
            this.origin = origin;
            return this;
        }

        public BoxColliderBuilder width(float width) {
            this.width = width;
            return this;
        }

        public BoxColliderBuilder height(float height) {
            this.height = height;
            return this;
        }
    }
}

