/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.gui.graphics;

import org.collebol.engine.EJGEngine;
import org.collebol.engine.math.CameraCalculator;
import org.collebol.shared.GameLocation;
import org.collebol.shared.math.Vector2D;

public class Camera {
    private Vector2D position;
    private float zoom;
    private Vector2D origin;
    private float rotation;
    private float[] ambientLight;
    private boolean lighting;
    private CameraCalculator calculator;
    private EJGEngine engine;

    public Camera(Vector2D position, float zoom, float rotation, EJGEngine e) {
        this.position = position;
        this.zoom = zoom;
        this.rotation = rotation;
        this.origin = new Vector2D(0.0f, 0.0f);
        this.calculator = new CameraCalculator(this, e);
        this.engine = e;
        this.ambientLight = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.lighting = false;
    }

    public Vector2D getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector2D origin) {
        this.origin = origin;
    }

    public void move(Vector2D delta) {
        this.position = this.position.add(delta);
    }

    public void zoom(float factor) {
        GameLocation loc = this.getGameLocation();
        this.zoom += factor;
        this.setGameLocation(loc);
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setPosition(Vector2D position) {
        this.position = position;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public CameraCalculator calculate() {
        return this.calculator;
    }

    public GameLocation getGameLocation() {
        if (this.position == null) {
            throw new RuntimeException("Position is null. Set a position before using!");
        }
        float x = this.position.getX() / (float)this.engine.getWindow().getTileSize() / this.zoom;
        float y = this.position.getY() / (float)this.engine.getWindow().getTileSize() / this.zoom;
        return new GameLocation(x, y);
    }

    public void setGameLocation(GameLocation location) {
        float x = (float)(location.getX() * (double)this.engine.getWindow().getTileSize() * (double)this.zoom);
        float y = (float)(location.getY() * (double)this.engine.getWindow().getTileSize() * (double)this.zoom);
        this.position = new Vector2D(x, y);
    }

    public float[] getAmbientLight() {
        return this.ambientLight;
    }

    public void setAmbientLight(float[] ambientLight) {
        this.ambientLight = ambientLight;
    }

    public boolean isLighting() {
        return this.lighting;
    }

    public void setLighting(boolean lighting) {
        this.lighting = lighting;
    }
}

