/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.gui.graphics.renderer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.collebol.engine.EJGEngine;
import org.collebol.engine.gui.graphics.Text;
import org.collebol.engine.gui.graphics.renderer.Renderer;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.nanovg.NanoVGGL2;

public class TextRenderer
extends Renderer {
    private long vg;
    private EJGEngine engine;
    private String name;
    private String fontPath;

    private EJGEngine getEngine() {
        return this.engine;
    }

    public TextRenderer(String name, String fontPath, EJGEngine e) {
        this.engine = e;
        this.name = name;
        this.fontPath = fontPath;
    }

    public void setup() {
        this.vg = NanoVGGL2.nvgCreate((int)3);
        if (this.vg == 0L) {
            throw new RuntimeException("Could not initialize NanoVG.");
        }
        int font = NanoVG.nvgCreateFont((long)this.vg, (CharSequence)this.name, (CharSequence)this.extractResourceToTempFile(this.fontPath));
        if (font == -1) {
            throw new RuntimeException("Could not add font.");
        }
    }

    public void render(Text text) {
        NanoVG.nvgBeginFrame((long)this.vg, (float)this.getEngine().getWindow().getWidth(), (float)this.getEngine().getWindow().getHeight(), (float)20.0f);
        NVGColor color = NVGColor.create();
        NanoVG.nvgRGBA((byte)-1, (byte)-1, (byte)-1, (byte)-1, (NVGColor)color);
        NanoVG.nvgSave((long)this.vg);
        NanoVG.nvgTranslate((long)this.vg, (float)text.getOrigin().getX(), (float)text.getOrigin().getY());
        NanoVG.nvgRotate((long)this.vg, (float)((float)Math.toRadians(text.getRotation())));
        NanoVG.nvgTranslate((long)this.vg, (float)(text.getPosition().getX() - text.getOrigin().getX()), (float)(text.getPosition().getY() - text.getOrigin().getY()));
        NanoVG.nvgFontSize((long)this.vg, (float)(text.getSize() * text.getScale()));
        NanoVG.nvgFontFace((long)this.vg, (CharSequence)this.name);
        NanoVG.nvgFillColor((long)this.vg, (NVGColor)color);
        NanoVG.nvgTextAlign((long)this.vg, (int)text.getAlign());
        NanoVG.nvgText((long)this.vg, (float)0.0f, (float)0.0f, (CharSequence)text.getText());
        NanoVG.nvgRestore((long)this.vg);
        NanoVG.nvgEndFrame((long)this.vg);
    }

    private String extractResourceToTempFile(String resourcePath) {
        String string;
        block16: {
            InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
            try {
                if (inputStream == null) {
                    throw new IllegalArgumentException("Resource not found: " + resourcePath);
                }
                File tempFile = Files.createTempFile("font", ".ttf", new FileAttribute[0]).toFile();
                tempFile.deleteOnExit();
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                string = tempFile.getAbsolutePath();
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load resource: " + resourcePath, e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public void cleanup() {
        NanoVGGL2.nvgDelete((long)this.vg);
    }

    public String getName() {
        return this.name;
    }

    public String getFontPath() {
        return this.fontPath;
    }
}

