/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.engine.gui.graphics.renderer;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.collebol.engine.EJGEngine;
import org.collebol.engine.gui.graphics.Light;
import org.collebol.engine.gui.graphics.Texture;
import org.collebol.engine.gui.graphics.renderer.Batch;
import org.collebol.engine.gui.graphics.renderer.Renderer;
import org.collebol.shared.math.Vector2D;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class TextureRenderer
extends Renderer {
    private String name;
    private float width;
    private float height;
    private Map<Integer, Texture> textures = new HashMap<Integer, Texture>();
    private List<Light> lights = new ArrayList<Light>();

    public TextureRenderer(String name, float width, float height) {
        this.name = name;
        this.width = width;
        this.height = height;
    }

    public TextureRenderer(String name, EJGEngine e) {
        this.name = name;
        this.width = e.getWindow().getTileSize();
        this.height = e.getWindow().getTileSize();
    }

    public void render(int id, Vector2D position, float scale, float rotation, Vector2D origin, boolean lighting) {
        if (lighting) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
        Texture texture = this.getTexture(id);
        texture.bind();
        float startX = position.getX();
        float startY = position.getY();
        float tWidth = this.width * scale;
        float tHeight = this.height * scale;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)origin.getX(), (float)origin.getY(), (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-origin.getX()), (float)(-origin.getY()), (float)0.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3553);
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)startX, (float)startY);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)startX, (float)(startY + tHeight));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(startX + tWidth), (float)(startY + tHeight));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(startX + tWidth), (float)startY);
        GL11.glEnd();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void renderBatch(Batch batch, boolean lighting) {
        if (lighting) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
        Texture texture = this.getTexture(batch.getTexture());
        texture.bind();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        for (Batch.BatchItem item : batch.getItems()) {
            float startX = item.position.getX();
            float startY = item.position.getY();
            float tWidth = this.width * item.scale;
            float tHeight = this.height * item.scale;
            double rad = Math.toRadians(item.rotation);
            float cos = (float)Math.cos(rad);
            float sin = (float)Math.sin(rad);
            float v0x = startX;
            float v0y = startY;
            float v1x = startX;
            float v1y = startY + tHeight;
            float v2x = startX + tWidth;
            float v2y = startY + tHeight;
            float v3x = startX + tWidth;
            float v3y = startY;
            float rv0x = item.origin.getX() + (v0x - item.origin.getX()) * cos - (v0y - item.origin.getY()) * sin;
            float rv0y = item.origin.getY() + (v0x - item.origin.getX()) * sin + (v0y - item.origin.getY()) * cos;
            float rv1x = item.origin.getX() + (v1x - item.origin.getX()) * cos - (v1y - item.origin.getY()) * sin;
            float rv1y = item.origin.getY() + (v1x - item.origin.getX()) * sin + (v1y - item.origin.getY()) * cos;
            float rv2x = item.origin.getX() + (v2x - item.origin.getX()) * cos - (v2y - item.origin.getY()) * sin;
            float rv2y = item.origin.getY() + (v2x - item.origin.getX()) * sin + (v2y - item.origin.getY()) * cos;
            float rv3x = item.origin.getX() + (v3x - item.origin.getX()) * cos - (v3y - item.origin.getY()) * sin;
            float rv3y = item.origin.getY() + (v3x - item.origin.getX()) * sin + (v3y - item.origin.getY()) * cos;
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)rv0x, (float)rv0y);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex2f((float)rv1x, (float)rv1y);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex2f((float)rv2x, (float)rv2y);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex2f((float)rv3x, (float)rv3y);
        }
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    public void applyLight(int id, Light light, float scale, float[] ambientColor) {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)(16384 + id));
        float lightX = light.getPosition().getX();
        float lightY = light.getPosition().getY();
        FloatBuffer lightPos = BufferUtils.createFloatBuffer((int)4);
        lightPos.put(new float[]{lightX, lightY, light.getRadius() * scale, 1.0f});
        lightPos.flip();
        GL11.glLightfv((int)(16384 + id), (int)4611, (FloatBuffer)lightPos);
        FloatBuffer lightColor = BufferUtils.createFloatBuffer((int)4);
        lightColor.put(light.getColor());
        lightColor.flip();
        GL11.glLightfv((int)(16384 + id), (int)4609, (FloatBuffer)lightColor);
        FloatBuffer ambientCl = BufferUtils.createFloatBuffer((int)4);
        ambientCl.put(ambientColor);
        ambientCl.flip();
        GL11.glLightfv((int)(16384 + id), (int)4608, (FloatBuffer)ambientCl);
    }

    public void registerTexture(Texture texture) {
        this.textures.put(texture.getId(), texture);
    }

    public Texture getTexture(int id) {
        if (this.textures.get(id) == null) {
            throw new RuntimeException("Invalid id of textures: " + id + ". Register Texture before using!");
        }
        return this.textures.get(id);
    }

    public String getName() {
        return this.name;
    }
}

