/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.collebol.server.ClientSession;
import org.collebol.server.ServerClient;
import org.collebol.server.ServerConsole;
import org.collebol.server.ServerState;

public abstract class Server
implements AutoCloseable {
    private final String host;
    private final int port;
    private static ServerSocket server;
    private static final ExecutorService pool;
    private static ServerState serverState;
    private HashMap<UUID, ServerClient> clientList = new HashMap();

    public Server(String host, int port, ServerState serverState) throws IOException {
        this.host = host;
        this.port = port;
        Server.serverState = serverState;
        server = new ServerSocket(port);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        this.starting();
        ServerConsole.server("Server is starting");
        this.running();
        ServerConsole.server("Server is running");
        serverState = ServerState.RUNNING;
        ServerConsole.server("Server is starting at: " + this.host + ":" + this.port);
        ServerConsole.consoleListener();
        try {
            while (serverState == ServerState.RUNNING) {
                try {
                    Socket clientSocket = server.accept();
                    pool.submit(() -> {
                        try (ClientSession session = new ClientSession(clientSocket, this);){
                            ServerConsole.server("Connection has been made[" + String.valueOf(clientSocket.getInetAddress()) + ":" + clientSocket.getPort() + "]");
                            session.handle();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (IOException e) {
                    if (!server.isClosed()) throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            this.stopping();
            ServerConsole.server("Server is stopped!");
        }
    }

    public abstract void starting();

    public abstract void running();

    public abstract void stopping();

    public static void shutdown() {
        try {
            serverState = ServerState.STOPPED;
            pool.shutdown();
            if (server != null && !server.isClosed()) {
                server.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws Exception {
    }

    static {
        pool = Executors.newCachedThreadPool();
    }
}

