/*
 * Decompiled with CFR 0.152.
 */
package org.collebol.client.gui;

import java.util.HashMap;
import org.collebol.client.EJGEngine;
import org.collebol.client.gui.Panel;
import org.collebol.client.input.KeyHandler;
import org.collebol.client.input.MouseHandler;
import org.collebol.client.utils.Time;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class MainWindow
implements Runnable {
    private EJGEngine engine;
    private String title = "EJGEngine";
    private int refreshInterval = 1;
    private int tileSize = 16;
    private int scale = 1;
    private int maxTileWidth = 19;
    private int maxTileHeight = 13;
    private int width = 960;
    private int height = 540;
    private long window;
    private MouseHandler mouseHandler;
    private KeyHandler keyHandler;
    private HashMap<Integer, Panel> panels = new HashMap();
    private Panel currentPanel;

    public MainWindow(EJGEngine e) {
        this.engine = e;
    }

    @Override
    public void run() {
        this.init();
        this.loop();
        GLFW.glfwDestroyWindow(this.window);
        GLFW.glfwTerminate();
    }

    private void init() {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW.");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 1);
        this.window = GLFW.glfwCreateWindow(this.getWidth(), this.getHeight(), this.getTitle(), 0L, 0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window.");
        }
        GLFW.glfwSetWindowPos(this.window, 100, 100);
        GLFW.glfwMakeContextCurrent(this.window);
        GLFW.glfwSwapInterval(this.refreshInterval);
        GLFW.glfwShowWindow(this.window);
        GLFW.glfwSetWindowRefreshCallback(this.window, window -> {
            GL11.glClear(16640);
            this.currentPanel.paint();
            GLFW.glfwSwapBuffers(window);
        });
        GLFW.glfwSetFramebufferSizeCallback(this.window, (window, width, height) -> {
            GL11.glViewport(0, 0, width, height);
            this.setWidth(width);
            this.setHeight(height);
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glOrtho(0.0, width, height, 0.0, -1.0, 1.0);
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
        });
        GL.createCapabilities();
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.getWidth(), this.getHeight(), 0.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        this.getEngine().register();
        this.mouseHandler = new MouseHandler(this.engine);
        this.mouseHandler.registerCallbacks(this.window);
        this.keyHandler = new KeyHandler(this.engine);
        this.keyHandler.keyCallback(this.window);
    }

    private void loop() {
        float beginTime = Time.getTime();
        float dt = -1.0f;
        while (!GLFW.glfwWindowShouldClose(this.window)) {
            GLFW.glfwPollEvents();
            GL11.glClear(16640);
            if (dt >= 0.0f) {
                this.currentPanel.update();
                this.currentPanel.setDT(dt);
                this.currentPanel.paint();
            }
            GLFW.glfwSwapBuffers(this.window);
            float endTime = Time.getTime();
            dt = endTime - beginTime;
            beginTime = endTime;
        }
    }

    public void showDevelopmentTools() {
        this.getEngine().getRenderers().getCameraRenderer().showGridLines();
        this.getEngine().getRenderers().getCameraRenderer().showOriginPoint();
        this.getEngine().getRenderers().getCameraRenderer().showCoordinates();
        this.getCurrentPanel().showScreenDetails();
    }

    private EJGEngine getEngine() {
        return this.engine;
    }

    public void registerPanel(Panel panel) {
        this.panels.put(panel.id, panel);
    }

    public void setPanel(int i) {
        if (this.panels.containsKey(i)) {
            this.currentPanel = this.panels.get(i);
        }
    }

    public Panel getCurrentPanel() {
        return this.currentPanel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        GLFW.glfwSetWindowTitle(this.window, this.getTitle());
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
        GLFW.glfwSwapInterval(this.refreshInterval);
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getMaxTileWidth() {
        return this.maxTileWidth;
    }

    public void setMaxTileWidth(int maxTileWidth) {
        this.maxTileWidth = maxTileWidth;
    }

    public int getMaxTileHeight() {
        return this.maxTileHeight;
    }

    public void setMaxTileHeight(int maxTileHeight) {
        this.maxTileHeight = maxTileHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public MouseHandler getMouseHandler() {
        return this.mouseHandler;
    }
}

